/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.encrypttools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import java.util.Optional;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.hiylo.components.commons.encrypttools.Base64;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Encrypt {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static Logger log = LoggerFactory.getLogger((String)Encrypt.class.getName());

    public static class Sha256 {
        public static String hmacSHA256(String data, String key) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(Encrypt.DEFAULT_ENCODING), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] array = sha256_HMAC.doFinal(data.getBytes(Encrypt.DEFAULT_ENCODING));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100), 1, 3);
            }
            return sb.toString().toUpperCase();
        }

        public static String sha256(String sortedParams) throws NoSuchAlgorithmException {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(sortedParams.getBytes());
            byte[] byteBuffer = messageDigest.digest();
            StringBuffer strHexString = new StringBuffer();
            for (int i = 0; i < byteBuffer.length; ++i) {
                String hex = Integer.toHexString(0xFF & byteBuffer[i]);
                if (hex.length() == 1) {
                    strHexString.append('0');
                }
                strHexString.append(hex);
            }
            return strHexString.toString();
        }
    }

    public static class Sha1 {
        public static String encript(String decript) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                try {
                    digest.update(decript.getBytes(Encrypt.DEFAULT_ENCODING));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                byte[] messageDigest = digest.digest();
                StringBuffer hexString = new StringBuffer();
                for (int i = 0; i < messageDigest.length; ++i) {
                    String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                    if (shaHex.length() < 2) {
                        hexString.append(0);
                    }
                    hexString.append(shaHex);
                }
                return hexString.toString();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return "";
            }
        }

        public static String encript(String decript, String charset) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-1");
                try {
                    if (StringUtils.isNotEmpty(charset)) {
                        digest.update(decript.getBytes(charset));
                    } else {
                        digest.update(decript.getBytes(Encrypt.DEFAULT_ENCODING));
                    }
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                byte[] messageDigest = digest.digest();
                StringBuffer hexString = new StringBuffer();
                for (int i = 0; i < messageDigest.length; ++i) {
                    String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
                    if (shaHex.length() < 2) {
                        hexString.append(0);
                    }
                    hexString.append(shaHex);
                }
                return hexString.toString();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    public static class Rsa {
        public static final String SIGN_ALGORITHMS = "SHA1WithRSA";

        public static String signWithPrivateKey(String content, String privateKey, String charset) {
            try {
                PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decode(privateKey));
                KeyFactory keyf = KeyFactory.getInstance("RSA");
                PrivateKey priKey = keyf.generatePrivate(priPKCS8);
                Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
                signature.initSign(priKey);
                signature.update(content.getBytes(charset));
                byte[] signed = signature.sign();
                return Base64.encode(signed);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public static byte[] encrypt(String plainBytes, String publicKey, int reserveSize, String cipherAlgorithm) {
            int keyByteSize = publicKey.length() / 8;
            int encryptBlockSize = keyByteSize - reserveSize;
            int nBlock = plainBytes.getBytes().length / encryptBlockSize;
            if (plainBytes.getBytes().length % encryptBlockSize != 0) {
                ++nBlock;
            }
            ByteArrayOutputStream outbuf = null;
            try {
                Cipher cipher = Cipher.getInstance(cipherAlgorithm);
                cipher.init(1, Rsa.getPublicKey(publicKey));
                outbuf = new ByteArrayOutputStream(nBlock * keyByteSize);
                for (int offset = 0; offset < plainBytes.getBytes().length; offset += encryptBlockSize) {
                    int inputLen = plainBytes.getBytes().length - offset;
                    if (inputLen > encryptBlockSize) {
                        inputLen = encryptBlockSize;
                    }
                    byte[] encryptedBlock = cipher.doFinal(plainBytes.getBytes(), offset, inputLen);
                    outbuf.write(encryptedBlock);
                }
                outbuf.flush();
                byte[] byArray = outbuf.toByteArray();
                return byArray;
            }
            catch (Exception e) {
                throw new RuntimeException("ENCRYPT ERROR:", e);
            }
            finally {
                Optional.ofNullable(outbuf).ifPresent(byteArrayOutputStream -> {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("CLOSE ByteArrayOutputStream ERROR:", e);
                    }
                });
                outbuf = null;
            }
        }

        public static String signWithPublicKey(String content, String publicKey, String charset) throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Rsa.getPublicKey(publicKey).getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pk = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pk);
            byte[] result = cipher.doFinal(content.getBytes());
            return Base64.encode(result);
        }

        public static boolean verify(String content, String sign, String publicKey, String charset) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                byte[] encodedKey = Base64.decode(publicKey);
                PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
                Signature signature = Signature.getInstance(SIGN_ALGORITHMS);
                signature.initVerify(pubKey);
                signature.update(content.getBytes(charset));
                boolean bverify = signature.verify(Base64.decode(sign));
                return bverify;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        public static String decrypt(String content, String privateKey, String charset) throws Exception {
            int bufl;
            PrivateKey prikey = Rsa.getPrivateKey(privateKey);
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, prikey);
            ByteArrayInputStream ins = new ByteArrayInputStream(Base64.decode(content));
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            byte[] buf = new byte[128];
            while ((bufl = ins.read(buf)) != -1) {
                byte[] block = null;
                if (buf.length == bufl) {
                    block = buf;
                } else {
                    block = new byte[bufl];
                    for (int i = 0; i < bufl; ++i) {
                        block[i] = buf[i];
                    }
                }
                writer.write(cipher.doFinal(block));
            }
            return new String(writer.toByteArray(), charset);
        }

        public static PrivateKey getPrivateKey(String key) throws Exception {
            byte[] keyBytes = Base64.decode(key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }

        public static RSAPublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
            byte[] keyBytes = Base64.decode(publicKey);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(spec);
        }
    }

    public static class Md5 {
        public static String sign(String text, String key, String charset) {
            text = text + key;
            return DigestUtils.md5Hex((byte[])Md5.getContentBytes(text, charset));
        }

        public static boolean verify(String text, String sign, String key, String charset) {
            text = text + key;
            String mysign = DigestUtils.md5Hex((byte[])Md5.getContentBytes(text, charset));
            return mysign.equals(sign);
        }

        private static byte[] getContentBytes(String content, String charset) {
            if (charset == null || "".equals(charset)) {
                try {
                    return content.getBytes(Encrypt.DEFAULT_ENCODING);
                }
                catch (UnsupportedEncodingException e) {
                    log.debug("encrypt", (Throwable)e);
                }
            }
            try {
                return content.getBytes(Objects.requireNonNull(charset));
            }
            catch (UnsupportedEncodingException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
            }
        }
    }

    public static enum SignType {
        MD5,
        HMACSHA256,
        SHA1;

    }
}

