/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.encrypttools;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.hiylo.components.commons.encrypttools.Encrypt;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtils {
    private static final String KEY = "epai";
    private static Logger log = LoggerFactory.getLogger(PasswordUtils.class.getClass());

    private PasswordUtils() {
    }

    public static String generateMd5Password(String password) {
        int end;
        int n = end = password.length() > 15 ? 15 : password.length();
        int begin = end > 10 ? 10 : (end <= 5 ? 0 : end - 5);
        return Encrypt.Md5.sign(password.substring(begin, end), KEY, "utf-8");
    }

    public static String generateHmacSHA256Password(String password) {
        try {
            int end;
            int n = end = password.length() > 15 ? 15 : password.length();
            int begin = end > 10 ? 10 : (end <= 5 ? 0 : end - 5);
            return Encrypt.Sha256.hmacSHA256(password.substring(begin, end), KEY);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            log.debug("password", (Throwable)e);
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_UNKNOWN_ERROR);
        }
    }

    public static String generateSha1Password(String password) {
        int end;
        int n = end = password.length() > 15 ? 15 : password.length();
        int begin = end > 10 ? 10 : (end <= 5 ? 0 : end - 5);
        return Encrypt.Sha1.encript(password.substring(begin, end));
    }
}

