/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.sf.json.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hiylo.components.commons.encrypttools.Encrypt;
import org.hiylo.components.commons.utils.DateUtils;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final Map<String, String> FILE_TYPE_MAP = new HashMap<String, String>();
    private static final String JPG = "jpg";
    private static final String BMP = "bmp";
    private static final String PNG = "png";
    private static final String GIF = "gif";
    private static final String COMMA = ",";

    public static Map<String, String> getFileTypeMap() {
        return FILE_TYPE_MAP;
    }

    public static String createToken() {
        return UUID.randomUUID().toString().replaceAll("-", "_");
    }

    public static String stringFilter(String str) throws PatternSyntaxException {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        return m.replaceAll("").trim();
    }

    public static boolean isImage(byte[] is) {
        String type = CommonUtils.getFileTypeByStream(is);
        return JPG.equals(type) || BMP.equals(type) || PNG.equals(type) || GIF.equals(type);
    }

    private static void getAllFileType() {
        FILE_TYPE_MAP.put(JPG, "FFD8FF");
        FILE_TYPE_MAP.put(PNG, "89504E47");
        FILE_TYPE_MAP.put(GIF, "47494638");
        FILE_TYPE_MAP.put("tif", "49492A00");
        FILE_TYPE_MAP.put(BMP, "424D");
        FILE_TYPE_MAP.put("dwg", "41433130");
        FILE_TYPE_MAP.put("html", "68746D6C3E");
        FILE_TYPE_MAP.put("rtf", "7B5C727466");
        FILE_TYPE_MAP.put("xml", "3C3F786D6C");
        FILE_TYPE_MAP.put("zip", "504B0304");
        FILE_TYPE_MAP.put("rar", "52617221");
        FILE_TYPE_MAP.put("psd", "38425053");
        FILE_TYPE_MAP.put("eml", "44656C69766572792D646174653A");
        FILE_TYPE_MAP.put("dbx", "CFAD12FEC5FD746F");
        FILE_TYPE_MAP.put("pst", "2142444E");
        FILE_TYPE_MAP.put("xls", "D0CF11E0");
        FILE_TYPE_MAP.put("doc", "D0CF11E0");
        FILE_TYPE_MAP.put("mdb", "5374616E64617264204A");
        FILE_TYPE_MAP.put("wpd", "FF575043");
        FILE_TYPE_MAP.put("eps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("ps", "252150532D41646F6265");
        FILE_TYPE_MAP.put("pdf", "255044462D312E");
        FILE_TYPE_MAP.put("qdf", "AC9EBD8F");
        FILE_TYPE_MAP.put("pwl", "E3828596");
        FILE_TYPE_MAP.put("wav", "57415645");
        FILE_TYPE_MAP.put("avi", "41564920");
        FILE_TYPE_MAP.put("ram", "2E7261FD");
        FILE_TYPE_MAP.put("rm", "2E524D46");
        FILE_TYPE_MAP.put("mpg", "000001BA");
        FILE_TYPE_MAP.put("mov", "6D6F6F76");
        FILE_TYPE_MAP.put("asf", "3026B2758E66CF11");
        FILE_TYPE_MAP.put("mid", "4D546864");
    }

    public static String getImageFileType(File f) {
        if (CommonUtils.isImage(f)) {
            try {
                ImageInputStream iis = ImageIO.createImageInputStream(f);
                Iterator<ImageReader> iter = ImageIO.getImageReaders(iis);
                if (!iter.hasNext()) {
                    return null;
                }
                ImageReader reader = iter.next();
                iis.close();
                return reader.getFormatName();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileByFile(File file) {
        String filetype = null;
        byte[] b = new byte[50];
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            int i = ((InputStream)is).read(b);
            if (i != -1) {
                filetype = CommonUtils.getFileTypeByStream(b);
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (Objects.nonNull(is)) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return filetype;
    }

    public static String getFileTypeByStream(byte[] b) {
        String filetypeHex = String.valueOf(CommonUtils.getFileHexString(b));
        for (Map.Entry<String, String> entry : FILE_TYPE_MAP.entrySet()) {
            String fileTypeHexValue = entry.getValue();
            if (!filetypeHex.toUpperCase().startsWith(fileTypeHexValue)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean isImage(File file) {
        boolean flag = false;
        try {
            BufferedImage bufreader = ImageIO.read(file);
            int width = bufreader.getWidth();
            int height = bufreader.getHeight();
            flag = width != 0 && height != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static String getFileHexString(byte[] b) {
        StringBuilder stringBuilder = new StringBuilder();
        if (b == null || b.length <= 0) {
            return null;
        }
        for (byte aB : b) {
            int v = aB & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String firstChatToUpcase(String word) {
        String result = word.substring(0, 1).toUpperCase();
        result = result + word.substring(1);
        return result;
    }

    public static List<Integer> convertStringToList(String str) {
        str = str.replace(" ", "").replace("[", "").replace("]", "");
        LinkedList<Integer> list = new LinkedList<Integer>();
        if (!"".equals(str) && str.length() > 0) {
            if (str.contains(COMMA)) {
                String[] strArr;
                for (String val : strArr = str.split(COMMA)) {
                    list.add(Integer.parseInt(val));
                }
            } else {
                list.add(Integer.parseInt(str));
            }
        }
        return list;
    }

    public static String jsonToXml(JSONObject jsonObject) {
        StringBuilder xmlStr = new StringBuilder();
        for (Object key : jsonObject.keySet()) {
            try {
                JSONObject sonJson = JSONObject.fromObject((Object)jsonObject.get(key));
                xmlStr.append("<").append(key).append(">").append(CommonUtils.jsonToXml(sonJson)).append("</").append(key).append(">");
            }
            catch (Exception e) {
                xmlStr.append("<").append(key).append(">").append(jsonObject.get(key)).append("</").append(key).append(">");
            }
        }
        return xmlStr.toString();
    }

    public static String mapToXml(Map map) {
        StringBuffer xmlBuffer = new StringBuffer();
        CommonUtils.mapToXmlCycle(map, xmlBuffer);
        return xmlBuffer.toString();
    }

    private static void mapToXmlCycle(Map map, StringBuffer xmlBuffer) {
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (null == value) {
                value = "";
            }
            if (Objects.nonNull(value.getClass().getName()) && value instanceof ArrayList) {
                ArrayList list = (ArrayList)map.get(key);
                xmlBuffer.append("<").append(key).append(">");
                for (Object aList : list) {
                    CommonUtils.mapToXmlCycle((Map)aList, xmlBuffer);
                }
                xmlBuffer.append("</").append(key).append(">");
                continue;
            }
            if (value instanceof HashMap) {
                xmlBuffer.append("<").append(key).append(">");
                CommonUtils.mapToXmlCycle((HashMap)value, xmlBuffer);
                xmlBuffer.append("</").append(key).append(">");
                continue;
            }
            if (value instanceof TreeMap) {
                xmlBuffer.append("<").append(key).append(">");
                CommonUtils.mapToXmlCycle((TreeMap)value, xmlBuffer);
                xmlBuffer.append("</").append(key).append(">");
                continue;
            }
            xmlBuffer.append("<").append(key).append("><![CDATA[").append(value).append("]]></").append(key).append(">");
        }
    }

    public static Map<String, Map<String, Object>> xml2Map(String xmlStr, String baseNodeName) throws DocumentException, SAXException {
        Document document = null;
        SAXReader reader = new SAXReader();
        String feature = null;
        feature = "http://apache.org/xml/features/disallow-doctype-decl";
        reader.setFeature(feature, true);
        feature = "http://xml.org/sax/features/external-general-entities";
        reader.setFeature(feature, false);
        feature = "http://xml.org/sax/features/external-parameter-entities";
        reader.setFeature(feature, false);
        feature = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        reader.setFeature(feature, false);
        String encoding = CommonUtils.getEncoding(xmlStr);
        InputSource source = new InputSource(new StringReader(xmlStr));
        source.setEncoding(encoding);
        document = reader.read(source);
        HashMap<String, Map<String, Object>> nodeMap = new HashMap<String, Map<String, Object>>(0, 0.75f);
        Element rootElement = document.getRootElement();
        if (baseNodeName.equals(rootElement.getName())) {
            nodeMap.put(baseNodeName, CommonUtils.getChildElements(rootElement.elements()));
            return nodeMap;
        }
        throw new RuntimeException("wrong baseNodeName");
    }

    private static String getEncoding(String text) {
        String result = null;
        String xml = text.trim();
        if (xml.startsWith("<?xml")) {
            int end = xml.indexOf("?>");
            String sub = xml.substring(0, end);
            StringTokenizer tokens = new StringTokenizer(sub, " =\"'");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                if (!"encoding".equals(token)) continue;
                if (!tokens.hasMoreTokens()) break;
                result = tokens.nextToken();
                break;
            }
        }
        return result;
    }

    public static Map<String, Object> getChildElements(List<Element> childElements) {
        HashMap<String, Object> nodeMap = new HashMap<String, Object>(0, 0.75f);
        for (Element element : childElements) {
            if (element.elements().size() == 0) {
                if (Objects.nonNull(element.attribute("name"))) {
                    nodeMap.put(element.attribute("name").getStringValue(), element.getStringValue());
                    continue;
                }
                nodeMap.put(element.getName(), element.getStringValue());
                continue;
            }
            nodeMap.put(element.getName(), CommonUtils.getChildElements(element.elements()));
        }
        return nodeMap;
    }

    public static String signWithMd5(Map<String, Object> paramMap, String md5Key, Boolean upperCase) throws UnsupportedEncodingException {
        if (Objects.nonNull(upperCase) && upperCase.booleanValue()) {
            return Encrypt.Md5.sign(CommonUtils.createSignParam(paramMap), md5Key, "utf-8").toUpperCase();
        }
        if (Objects.nonNull(upperCase) && !upperCase.booleanValue()) {
            return Encrypt.Md5.sign(CommonUtils.createSignParam(paramMap), md5Key, "utf-8").toLowerCase();
        }
        return Encrypt.Md5.sign(CommonUtils.createSignParam(paramMap), md5Key, "utf-8");
    }

    public static String signWithMd5(Map<String, Object> paramMap, String md5Key) throws UnsupportedEncodingException {
        return CommonUtils.signWithMd5(paramMap, md5Key, null);
    }

    public static String sign(Map<String, Object> paramMap, String signType, String key) throws UnsupportedEncodingException {
        if ("MD5".equals(signType)) {
            return CommonUtils.signWithMd5(paramMap, key, null);
        }
        if ("SHA256".equals(signType)) {
            try {
                return Encrypt.Sha256.hmacSHA256(CommonUtils.createSignParam(paramMap), key);
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
                log.error("\u7b7e\u540d", (Throwable)e);
            }
        }
        throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
    }

    public static String createSignParam(Map<String, Object> paramMap) throws UnsupportedEncodingException {
        StringBuilder signStr = new StringBuilder();
        TreeMap<String, Object> paramTreeMap = new TreeMap<String, Object>(paramMap);
        for (String key : paramMap.keySet()) {
            if (!Objects.nonNull(paramTreeMap.get(key)) || !StringUtils.isNotEmpty(paramTreeMap.get(key) + "")) continue;
            signStr.append(key).append("=").append(URLEncoder.encode(String.valueOf(paramTreeMap.get(key)), "UTF-8")).append("&");
        }
        return signStr.substring(0, signStr.length() - 1);
    }

    public static String removeLatestCharacter(String character) {
        return character.substring(0, character.length() - 1);
    }

    public static String mapToUriVariables(Map<String, String> map) {
        StringBuilder result = new StringBuilder();
        for (String key : map.keySet()) {
            if (!Objects.nonNull(map.get(key))) continue;
            result.append(key).append("=").append(map.get(key)).append("&");
        }
        return CommonUtils.removeLatestCharacter(result.toString());
    }

    public static String getNonceStr() {
        String currTime = DateUtils.formatDateToCustom(new Date(), "yyyyMMdd");
        String strTime = currTime.substring(8);
        String strRandom = String.valueOf(CommonUtils.buildRandom(4));
        String strReq = strTime + strRandom;
        return strReq;
    }

    public static int buildRandom(int length) {
        int num = 1;
        double random = Math.random();
        if (random < 0.1) {
            random += 0.1;
        }
        for (int i = 0; i < length; ++i) {
            num *= 10;
        }
        return (int)(random * (double)num);
    }

    static {
        CommonUtils.getAllFileType();
    }
}

