/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger log = LoggerFactory.getLogger(DateUtils.class);
    private final SimpleDateFormat standardSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final SimpleDateFormat standardSimpleDateFormatT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final SimpleDateFormat standardSimpleDateFormatTZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
    private final SimpleDateFormat standardSimpleTimeFormat = new SimpleDateFormat("HH:mm:ss");
    private final DateTimeFormatter standarDateTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final DateTimeFormatter standarDayTimeFormat = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static DateUtils dateUtils = new DateUtils();

    public SimpleDateFormat getStandardSimpleDateFormat() {
        return this.standardSimpleDateFormat;
    }

    public SimpleDateFormat getStandardSimpleDateFormatT() {
        return this.standardSimpleDateFormatT;
    }

    public SimpleDateFormat getStandardSimpleTimeFormat() {
        return this.standardSimpleTimeFormat;
    }

    public SimpleDateFormat getStandardSimpleDateFormatTZ() {
        return this.standardSimpleDateFormatTZ;
    }

    public DateTimeFormatter getStandarDataTimeFormat() {
        return this.standarDateTimeFormat;
    }

    public DateTimeFormatter getStandarDateTimeFormat() {
        return this.standarDateTimeFormat;
    }

    public DateTimeFormatter getStandarDayTimeFormat() {
        return this.standarDayTimeFormat;
    }

    public static String formatTimestampToStandardDateString(Timestamp timestamp) {
        if (Objects.nonNull(timestamp)) {
            return dateUtils.getStandardSimpleDateFormat().format(new Date(timestamp.getTime()));
        }
        throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
    }

    public static String formatTimestampToStandardDateStringTZ(Timestamp timestamp) {
        if (Objects.nonNull(timestamp)) {
            return dateUtils.getStandardSimpleDateFormatTZ().format(new Date(timestamp.getTime()));
        }
        throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
    }

    public static Date parseStandardDate(String date) {
        if (StringUtils.isEmpty(date)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            return dateUtils.getStandardSimpleDateFormat().parse(date);
        }
        catch (ParseException e) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static Timestamp parseStandardDateStringToTimestamp(String date) throws ParseException {
        if (StringUtils.isEmpty(date)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        long timestamp = dateUtils.getStandardSimpleDateFormat().parse(date).getTime();
        return new Timestamp(timestamp);
    }

    public static String formatNowToStandardDateFormat() {
        return dateUtils.getStandardSimpleDateFormat().format(new Date());
    }

    public static Timestamp parseStandardDateStringTToTimestamp(String date) throws ParseException {
        if (StringUtils.isEmpty(date)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        long timestamp = dateUtils.getStandardSimpleDateFormatT().parse(date).getTime();
        return new Timestamp(timestamp);
    }

    public static String formatTimestampToStandardDateStringT(Timestamp timestamp) {
        if (timestamp == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        return dateUtils.getStandardSimpleDateFormatT().format(new Date(timestamp.getTime()));
    }

    public static String formatLocalDateTimeToStandardDateString(LocalDateTime timestamp) {
        if (timestamp == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        return dateUtils.getStandarDataTimeFormat().format(timestamp);
    }

    public static Timestamp parseDateStringToTimestamp(String date) throws ParseException {
        if (StringUtils.isEmpty(date)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        try {
            return DateUtils.parseStandardDateStringToTimestamp(date);
        }
        catch (ParseException e) {
            try {
                return DateUtils.parseStandardDateStringTToTimestamp(date);
            }
            catch (ParseException e1) {
                log.debug("\u65e5\u671f\u8f6c\u6362\u9519\u8bef{} {}", (Object)date, (Object)e1);
                throw e1;
            }
        }
    }

    public static String computeDateString(String date, int field, int value) throws ParseException {
        if (StringUtils.isEmpty(date)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        Timestamp timestamp = DateUtils.parseStandardDateStringToTimestamp(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.add(field, value);
        return dateUtils.getStandardSimpleDateFormat().format(calendar.getTime());
    }

    public static Date getFirstDayMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        return calendar.getTime();
    }

    public static String getFirstDayMonthString() {
        return DateUtils.formatDateToStandardDateString(DateUtils.getFirstDayMonth());
    }

    public static String getBeginningOfTheDay(Date date) {
        date.setHours(0);
        date.setMinutes(0);
        date.setSeconds(0);
        return DateUtils.formatDateToStandardDateString(date);
    }

    public static String getEndOfTheDay(Date date) {
        date.setHours(23);
        date.setMinutes(59);
        date.setSeconds(59);
        return DateUtils.formatDateToStandardDateString(date);
    }

    public static String formatDateToStandardDateString(Date date) {
        if (date == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        return dateUtils.getStandardSimpleDateFormat().format(date);
    }

    public static String formatDateToCustom(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Date parseDateToCustom(String date, String format) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.parse(date);
    }

    public static boolean timeIsInRange(Date date, String startTime, String endTime, String pattern) {
        if (date == null || StringUtils.isEmpty(startTime, endTime, pattern)) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        Calendar item = Calendar.getInstance();
        item.setTime(date);
        try {
            Date startDate = sdf.parse(startTime);
            Date endDate = sdf.parse(endTime);
            Calendar start = Calendar.getInstance();
            start.setTime(startDate);
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            if (pattern.indexOf("yyyy") == -1) {
                start.set(1, item.get(1));
                end.set(1, item.get(1));
            }
            if (pattern.indexOf("MM") == -1) {
                start.set(2, item.get(2));
                end.set(2, item.get(2));
            }
            if (pattern.indexOf("dd") == -1) {
                start.set(6, item.get(6));
                end.set(6, item.get(6));
                start.set(5, item.get(5));
                end.set(5, item.get(5));
            }
            if (pattern.indexOf("HH") == -1) {
                start.set(10, item.get(10));
                end.set(10, item.get(10));
                start.set(11, item.get(11));
                end.set(11, item.get(11));
            }
            if (pattern.indexOf("mm") == -1) {
                start.set(12, item.get(12));
                end.set(12, item.get(12));
            }
            if (pattern.indexOf("ss") == -1) {
                start.set(13, item.get(13));
                end.set(13, item.get(13));
            }
            return item.getTimeInMillis() >= start.getTimeInMillis() && item.getTimeInMillis() <= end.getTimeInMillis();
        }
        catch (ParseException e) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
    }

    public static String getDateDescriptionDetail(Date date) {
        if (date == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar now = Calendar.getInstance();
        int dateDifference = calendar.get(6) - now.get(6);
        int yearDifference = calendar.get(1) - now.get(1);
        int monthDifference = calendar.get(2) - now.get(2);
        StringBuilder result = new StringBuilder();
        boolean currentYear = false;
        boolean currentMonth = false;
        if (yearDifference == 0) {
            currentYear = true;
        } else if (yearDifference == 1) {
            result.append("\u660e\u5e74");
        } else if (yearDifference == -1) {
            result.append("\u53bb\u5e74");
        } else {
            result.append(calendar.get(1) + "\u5e74");
        }
        if (currentYear) {
            if (monthDifference == 0) {
                currentMonth = true;
                result.append("\u672c\u6708");
            } else if (monthDifference == 1) {
                result.append("\u4e0b\u6708");
            } else if (monthDifference == -1) {
                result.append("\u4e0a\u6708");
            } else {
                result.append(calendar.get(2) + 1 + "\u6708");
            }
        } else {
            result.append(calendar.get(2) + 1 + "\u6708");
        }
        if (currentYear && currentMonth) {
            if (dateDifference == 1) {
                result.append("\u660e\u65e5");
            } else if (dateDifference == 0) {
                result.append("\u4eca\u65e5");
            } else if (dateDifference == -1) {
                result.append("\u6628\u65e5");
            } else {
                result.append(calendar.get(5) + "\u65e5");
            }
        } else {
            result.append(calendar.get(5) + "\u65e5");
        }
        return result.toString();
    }

    public static String getDateDescription(Date date) {
        if (date == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar now = Calendar.getInstance();
        int dateDifference = calendar.get(6) - now.get(6);
        int yearDifference = calendar.get(1) - now.get(1);
        int monthDifference = calendar.get(2) - now.get(2);
        StringBuilder result = new StringBuilder();
        if (yearDifference == 0 && monthDifference == 0) {
            if (dateDifference == 1) {
                result.append("\u660e\u65e5 ");
                result.append(calendar.get(11) + ":" + calendar.get(12));
                return result.toString();
            }
            if (dateDifference == 0) {
                result.append("\u4eca\u65e5 ");
                result.append(calendar.get(11) + ":" + calendar.get(12));
                return result.toString();
            }
        }
        return DateUtils.formatDateToStandardDateString(date);
    }

    public static boolean timeIsInRange(Date date, Time startTime, Time endTime) {
        if (date == null || startTime == null || endTime == null) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38");
        }
        Calendar item = Calendar.getInstance();
        item.setTime(date);
        String startTimeStr = startTime.getHours() + ":" + startTime.getMinutes() + ":" + startTime.getSeconds();
        String endTimeStr = endTime.getHours() + ":" + endTime.getMinutes() + ":" + endTime.getSeconds();
        return DateUtils.timeIsInRange(date, startTimeStr, endTimeStr, "HH:mm:ss");
    }

    public static String formatNowToStandardDateString() {
        return dateUtils.getStandardSimpleDateFormat().format(new Date());
    }

    public static String formatNowToStandardDateStringT() {
        return dateUtils.getStandardSimpleDateFormatT().format(new Date());
    }

    public static String formatToday() {
        return dateUtils.getStandarDayTimeFormat().format(LocalDateTime.now());
    }

    public static int getLastDateOfMonth(int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 2: {
                return new Date().getYear() + 0 == 0 ? 29 : 28;
            }
        }
        return 30;
    }
}

