/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hssf.usermodel.HSSFAnchor;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelUtils {
    public static String NO_DEFINE = "no_define";
    public static String DEFAULT_DATE_PATTERN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static int DEFAULT_COLOUMN_WIDTH = 17;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcel(String title, Map<String, String> headMap, JSONArray jsonArray, String datePattern, int colWidth, OutputStream out) {
        if (datePattern == null) {
            datePattern = DEFAULT_DATE_PATTERN;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            workbook.createInformationProperties();
            workbook.getDocumentSummaryInformation().setCompany("*****\u516c\u53f8");
            SummaryInformation si = workbook.getSummaryInformation();
            si.setAuthor("Ontheway");
            si.setApplicationName("Ontheway");
            si.setLastAuthor("Ontheway");
            si.setComments("Ontheway");
            si.setTitle(title);
            si.setSubject("POI\u5bfc\u51faExcel");
            si.setCreateDateTime(new Date());
            HSSFCellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setAlignment((short)2);
            HSSFFont titleFont = workbook.createFont();
            titleFont.setFontHeightInPoints((short)20);
            titleFont.setBoldweight((short)700);
            titleStyle.setFont(titleFont);
            HSSFCellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFillPattern((short)1);
            headerStyle.setBorderBottom((short)1);
            headerStyle.setBorderLeft((short)1);
            headerStyle.setBorderRight((short)1);
            headerStyle.setBorderTop((short)1);
            headerStyle.setAlignment((short)2);
            HSSFFont headerFont = workbook.createFont();
            headerFont.setFontHeightInPoints((short)12);
            headerFont.setBoldweight((short)700);
            headerStyle.setFont(headerFont);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setFillPattern((short)1);
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderRight((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            HSSFFont cellFont = workbook.createFont();
            cellFont.setBoldweight((short)400);
            cellStyle.setFont(cellFont);
            HSSFSheet sheet = workbook.createSheet();
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFComment comment = patriarch.createComment((HSSFAnchor)new HSSFClientAnchor(0, 0, 0, 0, 4, 2, 6, 5));
            comment.setString((RichTextString)new HSSFRichTextString("\u53ef\u4ee5\u5728POI\u4e2d\u6dfb\u52a0\u6ce8\u91ca\uff01"));
            comment.setAuthor("JACK");
            int minBytes = colWidth < DEFAULT_COLOUMN_WIDTH ? DEFAULT_COLOUMN_WIDTH : colWidth;
            int[] arrColWidth = new int[headMap.size()];
            String[] properties = new String[headMap.size()];
            String[] headers = new String[headMap.size()];
            int ii = 0;
            Iterator<String> iter = headMap.keySet().iterator();
            while (iter.hasNext()) {
                String fieldName;
                properties[ii] = fieldName = iter.next();
                headers[ii] = fieldName;
                int bytes = fieldName.getBytes().length;
                arrColWidth[ii] = bytes < minBytes ? minBytes : bytes;
                sheet.setColumnWidth(ii, arrColWidth[ii] * 256);
                ++ii;
            }
            int rowIndex = 0;
            for (Object obj : jsonArray) {
                int i;
                if (rowIndex == 65535 || rowIndex == 0) {
                    if (rowIndex != 0) {
                        sheet = workbook.createSheet();
                    }
                    HSSFRow titleRow = sheet.createRow(0);
                    titleRow.createCell(0).setCellValue(title);
                    titleRow.getCell(0).setCellStyle(titleStyle);
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headMap.size() - 1));
                    HSSFRow headerRow = sheet.createRow(1);
                    for (i = 0; i < headers.length; ++i) {
                        headerRow.createCell(i).setCellValue(headers[i]);
                        headerRow.getCell(i).setCellStyle(headerStyle);
                    }
                    rowIndex = 2;
                }
                JSONObject jo = JSONObject.fromObject(obj);
                HSSFRow dataRow = sheet.createRow(rowIndex);
                for (i = 0; i < properties.length; ++i) {
                    HSSFCell newCell = dataRow.createCell(i);
                    Object o = jo.get(properties[i]);
                    String cellValue = "";
                    cellValue = o == null ? "" : (o instanceof Date ? new SimpleDateFormat(datePattern).format(o) : o.toString());
                    newCell.setCellValue(cellValue);
                    newCell.setCellStyle(cellStyle);
                }
                ++rowIndex;
            }
        }
        finally {
            try {
                workbook.write(out);
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String exportExcelXToTmpPath(String title, Map<String, String> headMap, JSONArray jsonArray, String datePattern, int colWidth) throws IOException {
        File tempFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), "xlsx");
        ExcelUtils.exportExcelX(title, headMap, jsonArray, datePattern, colWidth, new FileOutputStream(tempFile));
        return tempFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcelX(String title, Map<String, String> headMap, JSONArray jsonArray, String datePattern, int colWidth, OutputStream out) {
        if (datePattern == null) {
            datePattern = DEFAULT_DATE_PATTERN;
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook(1000);
        try {
            workbook.setCompressTempFiles(true);
            CellStyle titleStyle = workbook.createCellStyle();
            titleStyle.setAlignment((short)2);
            Font titleFont = workbook.createFont();
            titleFont.setFontHeightInPoints((short)20);
            titleFont.setBoldweight((short)700);
            titleStyle.setFont(titleFont);
            CellStyle headerStyle = workbook.createCellStyle();
            headerStyle.setFillPattern((short)1);
            headerStyle.setBorderBottom((short)1);
            headerStyle.setBorderLeft((short)1);
            headerStyle.setBorderRight((short)1);
            headerStyle.setBorderTop((short)1);
            headerStyle.setAlignment((short)2);
            Font headerFont = workbook.createFont();
            headerFont.setFontHeightInPoints((short)12);
            headerFont.setBoldweight((short)700);
            headerStyle.setFont(headerFont);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setFillPattern((short)1);
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderRight((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            Font cellFont = workbook.createFont();
            cellFont.setBoldweight((short)400);
            cellStyle.setFont(cellFont);
            SXSSFSheet sheet = workbook.createSheet();
            int minBytes = colWidth < DEFAULT_COLOUMN_WIDTH ? DEFAULT_COLOUMN_WIDTH : colWidth;
            int[] arrColWidth = new int[headMap.size()];
            String[] properties = new String[headMap.size()];
            String[] headers = new String[headMap.size()];
            int ii = 0;
            Iterator<String> iter = headMap.keySet().iterator();
            while (iter.hasNext()) {
                String fieldName;
                properties[ii] = fieldName = iter.next();
                headers[ii] = headMap.get(fieldName);
                int bytes = fieldName.getBytes().length;
                arrColWidth[ii] = bytes < minBytes ? minBytes : bytes;
                sheet.setColumnWidth(ii, arrColWidth[ii] * 256);
                ++ii;
            }
            int rowIndex = 0;
            for (Object obj : jsonArray) {
                int i;
                if (rowIndex == 65535 || rowIndex == 0) {
                    if (rowIndex != 0) {
                        sheet = workbook.createSheet();
                    }
                    SXSSFRow titleRow = sheet.createRow(0);
                    titleRow.createCell(0).setCellValue(title);
                    titleRow.getCell(0).setCellStyle(titleStyle);
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, headMap.size() - 1));
                    SXSSFRow headerRow = sheet.createRow(1);
                    for (i = 0; i < headers.length; ++i) {
                        headerRow.createCell(i).setCellValue(headers[i]);
                    }
                    rowIndex = 2;
                }
                JSONObject jo = JSONObject.fromObject(obj);
                SXSSFRow dataRow = sheet.createRow(rowIndex);
                for (i = 0; i < properties.length; ++i) {
                    SXSSFCell newCell = dataRow.createCell(i);
                    Object o = jo.get(properties[i]);
                    String cellValue = "";
                    if (o == null) {
                        cellValue = "";
                    } else if (o instanceof Date) {
                        cellValue = new SimpleDateFormat(datePattern).format(o);
                    } else if (o instanceof Timestamp) {
                        Timestamp timestamp = (Timestamp)o;
                        cellValue = new SimpleDateFormat(datePattern).format(new Date(timestamp.getTime()));
                    } else {
                        cellValue = o instanceof Float || o instanceof Double ? new BigDecimal(o.toString()).setScale(2, 4).toString() : o.toString();
                    }
                    newCell.setCellValue(cellValue);
                }
                ++rowIndex;
            }
        }
        finally {
            try {
                workbook.write(out);
                workbook.close();
                workbook.dispose();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void downloadExcelFile(String title, Map<String, String> headMap, JSONArray ja, HttpServletResponse response) {
        try {
            int bytesRead;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ExcelUtils.exportExcelX(title, headMap, ja, null, 0, os);
            byte[] content = os.toByteArray();
            ByteArrayInputStream is = new ByteArrayInputStream(content);
            response.reset();
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((title + ".xlsx").getBytes(), "iso-8859-1"));
            response.setContentLength(content.length);
            ServletOutputStream outputStream = response.getOutputStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)outputStream);
            byte[] buff = new byte[8192];
            while (-1 != (bytesRead = bis.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bis.close();
            bos.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

