/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.hiylo.components.commons.utils.CommonUtils;
import org.hiylo.components.commons.utils.MyX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final String CHARSET = "utf-8";
    private Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String jsonStr) {
        log.debug(jsonStr);
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpPost method = new HttpPost(url);
            if (jsonStr != null && !"".equals(jsonStr)) {
                method.addHeader("Content-Type", "application/json");
                StringEntity strEntity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
                strEntity.setContentType("application/json");
                strEntity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                method.setEntity((HttpEntity)strEntity);
            }
            if ((entity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
        }
        catch (IOException e) {
            log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                client.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            }
        }
        log.debug(responseText);
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> params, String encoding) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpGet method;
            HttpEntity entity;
            StringBuilder param = new StringBuilder("?");
            if (params != null) {
                for (Map.Entry<String, String> p : params.entrySet()) {
                    param.append(p.getKey()).append("=").append(p.getValue()).append("&");
                }
            }
            if ((entity = (response = client.execute((HttpUriRequest)(method = new HttpGet(url + param)))).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)encoding);
            }
        }
        catch (IOException e) {
            log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                client.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            }
        }
        return responseText;
    }

    public static String sendPost(String url, String param) throws UnsupportedEncodingException {
        return HttpClient.sendPost(url, param, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String param, String contentType) throws UnsupportedEncodingException {
        PrintWriter out = null;
        BufferedReader in = null;
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection urlConnection = realUrl.openConnection();
            HttpURLConnection conn = (HttpURLConnection)urlConnection;
            Optional.ofNullable(contentType).ifPresent(s -> conn.setRequestProperty("Content-Type", (String)s));
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept-Charset", "UTF-8");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                log.debug("\u8bf7\u6c42\u51fa\u9519", (Throwable)ex);
            }
        }
        return new String(result.toString().getBytes(), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, Object> params, Map<String, Object> headers) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity httpEntity;
            String param = "?";
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    param = param + entry.getKey() + "=" + entry.getValue() + "&";
                }
            }
            HttpGet method = new HttpGet(url + param);
            if (headers != null) {
                for (Map.Entry<String, Object> entry : headers.entrySet()) {
                    method.setHeader(entry.getKey(), String.valueOf(entry.getValue()));
                }
            }
            if ((httpEntity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String url, Map<String, String> params, String encoding) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity entity;
            HttpPost method = new HttpPost(url);
            if (params != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(10);
                for (Map.Entry<String, String> param : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, encoding));
            }
            if ((entity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String url, Map<String, String> params, Map<String, String> headers, String encoding) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost method = new HttpPost(url);
            if (params != null) {
                ArrayList paramList = new ArrayList(params.size());
                for (Map.Entry<String, String> param : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity((List)paramList, encoding));
            }
            if (headers != null) {
                for (Map.Entry entry : headers.entrySet()) {
                    method.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            response = client.execute((HttpUriRequest)method);
            log.debug(new Gson().toJson((Object)response.getAllHeaders()));
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postGetHeader(String url, Map<String, String> params, Map<String, String> headers, String encoding, String headerName) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseHeader = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost method = new HttpPost(url);
            if (params != null) {
                ArrayList<BasicNameValuePair> paramList = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> param : params.entrySet()) {
                    BasicNameValuePair pair = new BasicNameValuePair(param.getKey(), param.getValue());
                    paramList.add(pair);
                }
                method.setEntity((HttpEntity)new UrlEncodedFormEntity(paramList, encoding));
            }
            if (headers != null) {
                for (Map.Entry<String, String> param : headers.entrySet()) {
                    method.addHeader(param.getKey(), param.getValue());
                }
            }
            response = client.execute((HttpUriRequest)method);
            System.out.println(new Gson().toJson((Object)response.getAllHeaders()));
            for (Header header : response.getAllHeaders()) {
                if (!header.getName().equals(headerName)) continue;
                responseHeader = header.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postJson(String url, Map<String, Object> params, Map<String, String> headers) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            Object entity;
            HttpPost method = new HttpPost(url);
            if (params != null) {
                entity = new BasicHttpEntity();
                entity.setContentType("application/json;charset=UTF-8");
                entity.setContent((InputStream)new ByteArrayInputStream(this.gson.toJson(params).getBytes("UTF-8")));
                method.setEntity((HttpEntity)entity);
            }
            if (headers != null) {
                entity = headers.entrySet().iterator();
                while (entity.hasNext()) {
                    Map.Entry param = (Map.Entry)entity.next();
                    method.addHeader((String)param.getKey(), (String)param.getValue());
                }
            }
            if ((entity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postHttpsWithPkcs(String url, String method, String outputStr, InputStream pkcs, String password, String encoding) {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpPost post = new HttpPost(url);
            StringEntity strEntity = new StringEntity(outputStr);
            post.setEntity((HttpEntity)strEntity);
            response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                responseText = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    public String httpsRequest(String requestUrl, String requestMethod, String outputStr) {
        Object result = null;
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(ssf);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod(requestMethod);
            if (outputStr != null) {
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(outputStr.getBytes(StandardCharsets.UTF_8));
                outputStream.close();
            }
            InputStream inputStream = conn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
            String str = null;
            StringBuffer buffer = new StringBuffer();
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            conn.disconnect();
            return buffer.toString();
        }
        catch (ConnectException connectException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final String get(String url) throws ParseException, IOException {
        HttpGet request = new HttpGet(url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() == 200) {
            return EntityUtils.toString((HttpEntity)response.getEntity(), (String)CHARSET);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, Map<String, String> params, Map<String, String> headers, String charset) throws ParseException, IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        String responseText = "";
        CloseableHttpResponse response = null;
        try {
            HttpEntity httpEntity;
            StringBuilder param = new StringBuilder("?");
            if (params != null) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    param.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
                }
            }
            HttpGet method = new HttpGet(url + param);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    method.addHeader(entry.getKey(), entry.getValue());
                }
            }
            if ((httpEntity = (response = client.execute((HttpUriRequest)method)).getEntity()) != null) {
                responseText = EntityUtils.toString((HttpEntity)httpEntity, (String)CHARSET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                response.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return responseText;
    }

    public String urlEncodeUTF8(String source) {
        String result = source;
        try {
            result = URLEncoder.encode(source, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getFileExt(String contentType) {
        String fileExt = "";
        if (CommonUtils.getFileTypeMap().get("image/jpeg") != null && CommonUtils.getFileTypeMap().get("image/jpeg").equals(contentType)) {
            fileExt = ".jpg";
        } else if (CommonUtils.getFileTypeMap().get("audio/mpeg") != null && CommonUtils.getFileTypeMap().get("audio/mpeg").equals(contentType)) {
            fileExt = ".mp3";
        } else if (CommonUtils.getFileTypeMap().get("audio/amr") != null && CommonUtils.getFileTypeMap().get("audio/amr").equals(contentType)) {
            fileExt = ".amr";
        } else if (CommonUtils.getFileTypeMap().get("video/mp4") != null && CommonUtils.getFileTypeMap().get("video/mp4").equals(contentType)) {
            fileExt = ".mp4";
        } else if (CommonUtils.getFileTypeMap().get("video/mpeg4") != null && CommonUtils.getFileTypeMap().get("video/mpeg4").equals(contentType)) {
            fileExt = ".mp4";
        }
        return fileExt;
    }
}

