/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hiylo.components.commons.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdcardUtils
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(IdcardUtils.class);
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    protected static final String[] CITY_CODE = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    protected static final String[] VERIFY_CODE = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final int MIN = 1930;
    private static Map<String, String> cityCodes = new HashMap<String, String>();
    private static Map<String, Integer> twFirstCodes = new HashMap<String, Integer>();
    private static Map<String, Integer> hkFirstCode = new HashMap<String, Integer>();

    public static String conver15CardTo18(String idCard) {
        String sVal;
        String idCard18 = "";
        if (idCard.length() != 15) {
            return null;
        }
        if (IdcardUtils.isNum(idCard)) {
            String birthday = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                log.debug("idcard", (Throwable)e);
            }
            Calendar cal = Calendar.getInstance();
            if (Objects.nonNull(birthDate)) {
                cal.setTime(birthDate);
            }
            String sYear = String.valueOf(cal.get(1));
            idCard18 = idCard.substring(0, 6) + sYear + idCard.substring(8);
            char[] cArr = idCard18.toCharArray();
            int[] iCard = IdcardUtils.converCharToInt(cArr);
            int iSum17 = IdcardUtils.getPowerSum(iCard);
            sVal = IdcardUtils.getCheckCode18(iSum17);
            if (sVal.length() <= 0) {
                return null;
            }
        } else {
            return null;
        }
        idCard18 = idCard18 + sVal;
        return idCard18;
    }

    public static boolean validateCard(String idCard) {
        String card = idCard.trim();
        if (IdcardUtils.validateIdCard18(card)) {
            return true;
        }
        if (IdcardUtils.validateIdCard15(card)) {
            return true;
        }
        String[] cardval = IdcardUtils.validateIdCard10(card);
        if (Objects.nonNull(cardval)) {
            return cardval[2].equals("true");
        }
        return false;
    }

    public static boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard.length() == 18) {
            char[] cArr;
            int[] iCard;
            int iSum17;
            String val;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (IdcardUtils.isNum(code17) && (val = IdcardUtils.getCheckCode18(iSum17 = IdcardUtils.getPowerSum(iCard = IdcardUtils.converCharToInt(cArr = code17.toCharArray())))).length() > 0 && val.equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue;
    }

    public static boolean validateIdCard15(String idCard) {
        if (idCard.length() != 15) {
            return false;
        }
        if (IdcardUtils.isNum(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (cityCodes.get(proCode) == null) {
                return false;
            }
            String birthCode = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                log.debug("idcard", (Throwable)e);
            }
            Calendar cal = Calendar.getInstance();
            if (Objects.nonNull(birthDate)) {
                cal.setTime(birthDate);
            }
            return IdcardUtils.validate(cal.get(1), Integer.valueOf(birthCode.substring(2, 4)), Integer.valueOf(birthCode.substring(4, 6)));
        }
        return false;
    }

    public static String[] validateIdCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return new String[0];
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            String char2 = idCard.substring(1, 2);
            if (char2.equals("1")) {
                info[1] = "M";
            } else if (char2.equals("2")) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = IdcardUtils.validateTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = IdcardUtils.validateHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean validateTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        int iStart = twFirstCodes.get(start);
        int sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.valueOf(c + "") * iflag;
            --iflag;
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean validateHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        int sum = 0;
        if (card.length() == 9) {
            sum = (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (card.substring(0, 1).toUpperCase().toCharArray()[0] - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.valueOf(c + "") * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.valueOf(end).intValue());
        return sum % 11 == 0;
    }

    public static int[] converCharToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            log.debug("idcard", (Throwable)e);
        }
        return iArr;
    }

    public static int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < POWER.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * POWER[j];
                }
            }
        }
        return iSum;
    }

    public static String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
                break;
            }
        }
        return sCode;
    }

    public static int getAgeByIdCard(String idCard) {
        int iAge = 0;
        if (idCard.length() == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        String year = Objects.requireNonNull(idCard).substring(6, 10);
        Calendar cal = Calendar.getInstance();
        int iCurrYear = cal.get(1);
        iAge = iCurrYear - Integer.valueOf(year);
        return iAge;
    }

    public static String getBirthByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        return Objects.requireNonNull(idCard).substring(6, 14);
    }

    public static Short getYearByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(10, 12));
    }

    public static Short getDateByIdCard(String idCard) {
        int len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        return Short.valueOf(Objects.requireNonNull(idCard).substring(12, 14));
    }

    public static String getGenderByIdCard(String idCard) {
        String sCardNum;
        if (idCard.length() == 15) {
            idCard = IdcardUtils.conver15CardTo18(idCard);
        }
        String sGender = Integer.parseInt(sCardNum = Objects.requireNonNull(idCard).substring(16, 17)) % 2 != 0 ? "01" : "02";
        return sGender;
    }

    public static String getProvinceByIdCard(String idCard) {
        int len = idCard.length();
        String sProvince = null;
        String sProvinNum = "";
        if (len == 15 || len == 18) {
            sProvinNum = idCard.substring(0, 2);
        }
        sProvince = cityCodes.get(sProvinNum);
        return sProvince;
    }

    public static boolean isNum(String val) {
        return StringUtils.isNotEmpty(val) && val.matches("^[0-9]*$");
    }

    public static boolean validate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > 1930;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    public static boolean isTrue(String idcard) {
        try {
            return IdcardUtils.validateCard(idcard);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        cityCodes.put("11", "\u5317\u4eac");
        cityCodes.put("12", "\u5929\u6d25");
        cityCodes.put("13", "\u6cb3\u5317");
        cityCodes.put("14", "\u5c71\u897f");
        cityCodes.put("15", "\u5185\u8499\u53e4");
        cityCodes.put("21", "\u8fbd\u5b81");
        cityCodes.put("22", "\u5409\u6797");
        cityCodes.put("23", "\u9ed1\u9f99\u6c5f");
        cityCodes.put("31", "\u4e0a\u6d77");
        cityCodes.put("32", "\u6c5f\u82cf");
        cityCodes.put("33", "\u6d59\u6c5f");
        cityCodes.put("34", "\u5b89\u5fbd");
        cityCodes.put("35", "\u798f\u5efa");
        cityCodes.put("36", "\u6c5f\u897f");
        cityCodes.put("37", "\u5c71\u4e1c");
        cityCodes.put("41", "\u6cb3\u5357");
        cityCodes.put("42", "\u6e56\u5317");
        cityCodes.put("43", "\u6e56\u5357");
        cityCodes.put("44", "\u5e7f\u4e1c");
        cityCodes.put("45", "\u5e7f\u897f");
        cityCodes.put("46", "\u6d77\u5357");
        cityCodes.put("50", "\u91cd\u5e86");
        cityCodes.put("51", "\u56db\u5ddd");
        cityCodes.put("52", "\u8d35\u5dde");
        cityCodes.put("53", "\u4e91\u5357");
        cityCodes.put("54", "\u897f\u85cf");
        cityCodes.put("61", "\u9655\u897f");
        cityCodes.put("62", "\u7518\u8083");
        cityCodes.put("63", "\u9752\u6d77");
        cityCodes.put("64", "\u5b81\u590f");
        cityCodes.put("65", "\u65b0\u7586");
        cityCodes.put("71", "\u53f0\u6e7e");
        cityCodes.put("81", "\u9999\u6e2f");
        cityCodes.put("82", "\u6fb3\u95e8");
        cityCodes.put("91", "\u56fd\u5916");
        twFirstCodes.put("A", 10);
        twFirstCodes.put("B", 11);
        twFirstCodes.put("C", 12);
        twFirstCodes.put("D", 13);
        twFirstCodes.put("E", 14);
        twFirstCodes.put("F", 15);
        twFirstCodes.put("G", 16);
        twFirstCodes.put("H", 17);
        twFirstCodes.put("J", 18);
        twFirstCodes.put("K", 19);
        twFirstCodes.put("L", 20);
        twFirstCodes.put("M", 21);
        twFirstCodes.put("N", 22);
        twFirstCodes.put("P", 23);
        twFirstCodes.put("Q", 24);
        twFirstCodes.put("R", 25);
        twFirstCodes.put("S", 26);
        twFirstCodes.put("T", 27);
        twFirstCodes.put("U", 28);
        twFirstCodes.put("V", 29);
        twFirstCodes.put("X", 30);
        twFirstCodes.put("Y", 31);
        twFirstCodes.put("W", 32);
        twFirstCodes.put("Z", 33);
        twFirstCodes.put("I", 34);
        twFirstCodes.put("O", 35);
        hkFirstCode.put("A", 1);
        hkFirstCode.put("B", 2);
        hkFirstCode.put("C", 3);
        hkFirstCode.put("R", 18);
        hkFirstCode.put("U", 21);
        hkFirstCode.put("Z", 26);
        hkFirstCode.put("X", 24);
        hkFirstCode.put("W", 23);
        hkFirstCode.put("O", 15);
        hkFirstCode.put("N", 14);
    }
}

