/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;

public class ImageUtils {
    private Thumbnails.Builder<? extends InputStream> buildThumbnails(InputStream inputStream, int newWidth, int newHeight, boolean forceResize) {
        Thumbnails.Builder of = Thumbnails.of((InputStream[])new InputStream[]{inputStream});
        of = forceResize ? of.forceSize(newWidth, newHeight) : of.width(newWidth).height(newHeight);
        return of;
    }

    public InputStream resize(InputStream inputStream, int newWidth, int newHeight, boolean forceResize) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Thumbnails.Builder<? extends InputStream> of = this.buildThumbnails(inputStream, newWidth, newHeight, forceResize);
        ImageIO.write((RenderedImage)of.asBufferedImage(), "png", os);
        ByteArrayInputStream input = new ByteArrayInputStream(os.toByteArray());
        return input;
    }

    public void resize(InputStream inputStream, OutputStream outputStream, int newWidth, int newHeight, boolean forceResize) throws IOException {
        Thumbnails.Builder<? extends InputStream> of = this.buildThumbnails(inputStream, newWidth, newHeight, forceResize);
        of.toOutputStream(outputStream);
    }

    public int getAspectRatio(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return bufferedImage.getWidth() / bufferedImage.getHeight();
    }
}

