/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Json {
    private static final Logger log = LoggerFactory.getLogger(Json.class);
    private static Gson gson = new Gson();

    private Json() {
    }

    public static Map<String, Object> toMap(String json) {
        return (Map)gson.fromJson(json, Map.class);
    }

    public static String toJson(Object object) {
        String json = gson.toJson(object);
        if (JSON.isValidObject((String)json)) {
            JSONObject jsonObject = JSON.parseObject((String)json);
            jsonObject.put("class", object.getClass());
            return jsonObject.toJSONString();
        }
        if (JSON.isValidArray((String)json)) {
            List list = (List)object;
            Object o = list.get(0);
            JSONArray jsonArray = JSON.parseArray((String)json);
            JSONArray array = new JSONArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                jsonObject.put("class", o.getClass());
                array.add((Object)jsonObject);
            }
            return array.toJSONString();
        }
        return null;
    }

    public static Object parse(String json) {
        JSONArray jsonArray;
        int i;
        log.debug(json);
        if (StringUtils.isEmpty(json)) {
            throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"Value is empty!");
        }
        if (JSON.isValidObject((String)json)) {
            JSONObject jsonObject = JSON.parseObject((String)json);
            if (Objects.isNull(jsonObject)) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"Value is not a json!");
            }
            String clazzStr = jsonObject.getString("class");
            if (StringUtils.isEmpty(clazzStr)) {
                return jsonObject;
            }
            try {
                Class<?> clazz = Class.forName(clazzStr);
                log.debug(jsonObject.toJSONString());
                Object object = gson.fromJson(json, clazz);
                log.debug(String.valueOf(object));
                return object;
            }
            catch (ClassNotFoundException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"Class not found!");
            }
        }
        if (JSON.isValidArray((String)json) && (i = 0) < (jsonArray = JSON.parseArray((String)json)).size()) {
            String clazzStr = jsonArray.getJSONObject(i).getString("class");
            if (StringUtils.isEmpty(clazzStr)) {
                return jsonArray.getJSONObject(i);
            }
            try {
                Class<?> clazz = Class.forName(clazzStr);
                log.debug(jsonArray.getJSONObject(i).toJSONString());
                Object object = gson.fromJson(json, clazz);
                log.debug(String.valueOf(object));
                return object;
            }
            catch (ClassNotFoundException e) {
                throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL, (String)"Class not found!");
            }
        }
        return null;
    }

    public static Integer getInteger(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getInteger(field);
    }

    public static String getString(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getString(field);
    }

    public static Boolean getBoolean(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getBoolean(field);
    }

    public static Short getShort(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getShort(field);
    }

    public static Byte getByte(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getByte(field);
    }

    public static List<String> getStringList(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getJSONArray(field).toJavaList(String.class);
    }

    public static List<Integer> getIntegerList(String body, String field) {
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getJSONArray(field).toJavaList(Integer.class);
    }
}

