/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;

public class NetworkUtils {
    public static boolean hasPulibcNewworkAccess() {
        int status = 404;
        try {
            URL urlObj = new URL("http://www.baidu.com");
            HttpURLConnection oc = (HttpURLConnection)urlObj.openConnection();
            oc.setUseCaches(false);
            oc.setConnectTimeout(3000);
            status = oc.getResponseCode();
            if (200 == status) {
                return true;
            }
        }
        catch (Exception e) {
            if (e instanceof UnknownHostException) {
                return false;
            }
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static boolean ping(String ip) {
        int timeOut = 3000;
        boolean status = false;
        try {
            status = InetAddress.getByName(ip).isReachable(timeOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String getRequestUserIp(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }
}

