/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class NumberUtils {
    private static final int DEF_DIV_SCALE = 10;

    public static String castDoublePriceToString(double price) {
        return NumberUtils.castDoubleKeepTwoDecimalPlaces(price);
    }

    public static String castDoubleKeepTwoDecimalPlaces(double price) {
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        return decimalFormat.format(price);
    }

    public static boolean greaterThanZero(int ... values) {
        for (int value : values) {
            if (value > 0) continue;
            return false;
        }
        return true;
    }

    public static boolean lessThanZero(int ... values) {
        for (int value : values) {
            if (value <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAndGreaterThanZero(int ... values) {
        for (int value : values) {
            if (value >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean greaterThanZero(double ... values) {
        for (double value : values) {
            if (!(value <= 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean lessThan(int src, int ... values) {
        for (int value : values) {
            if (value < src) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAndLessThan(int src, int ... values) {
        for (int value : values) {
            if (value <= src) continue;
            return false;
        }
        return true;
    }

    public static boolean lessThan(double src, double ... values) {
        for (double value : values) {
            if (!(value >= src)) continue;
            return false;
        }
        return true;
    }

    public static boolean greaterThan(double src, double ... values) {
        for (double value : values) {
            if (!(value < src)) continue;
            return false;
        }
        return true;
    }

    public static Double add(Double v1, Double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.add(b2).doubleValue();
    }

    public static Double sub(Double v1, Double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.subtract(b2).doubleValue();
    }

    public static Double mul(Double v1, Double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.multiply(b2).doubleValue();
    }

    public static Double div(Double v1, Double v2) {
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, 10, RoundingMode.HALF_UP).doubleValue();
    }

    public static Double div(Double v1, Double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = BigDecimal.valueOf(v1);
        BigDecimal b2 = BigDecimal.valueOf(v2);
        return b1.divide(b2, scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static Double round(Double v1) {
        DecimalFormat df = new DecimalFormat("#.00");
        return Double.parseDouble(df.format(v1));
    }

    public static Double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = BigDecimal.valueOf(v);
        return b.setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    public static String round(String v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(v);
        return b.setScale(scale, 4).toString();
    }

    public static String formatString(double d) {
        BigDecimal b = new BigDecimal(d);
        return b.toString();
    }

    public static double formatDouble(String s) {
        BigDecimal b = new BigDecimal(s);
        return b.doubleValue();
    }

    public static Double noRound(Double v1) {
        DecimalFormat formater = new DecimalFormat();
        formater.setMaximumFractionDigits(2);
        formater.setGroupingSize(0);
        formater.setRoundingMode(RoundingMode.FLOOR);
        return Double.parseDouble(formater.format(v1));
    }

    public static Double noRound(Double v1, int digits) {
        DecimalFormat formater = new DecimalFormat();
        formater.setMaximumFractionDigits(digits);
        formater.setGroupingSize(0);
        formater.setRoundingMode(RoundingMode.FLOOR);
        return Double.parseDouble(formater.format(v1));
    }

    public static String decimalFormat(Double v1) {
        DecimalFormat df = new DecimalFormat("#0.00");
        df.setMaximumFractionDigits(2);
        df.setGroupingSize(0);
        df.setRoundingMode(RoundingMode.FLOOR);
        return df.format(v1);
    }

    public static String clearZero(Double aDouble) {
        DecimalFormat decimalFormat = new DecimalFormat("###################.###########");
        return decimalFormat.format(aDouble);
    }

    public static boolean isNan(String ... numbers) {
        for (String number : numbers) {
            try {
                Double.parseDouble(number);
            }
            catch (NullPointerException | NumberFormatException e) {
                return true;
            }
        }
        return false;
    }
}

