/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);
    private static Properties props;

    public PropertiesUtils() {
        PropertiesUtils.loadProps();
    }

    private static void loadProps() {
        props = new Properties();
        URL classPath = PropertiesUtils.class.getClass().getResource("/");
        File root = new File(Objects.requireNonNull(classPath).getFile());
        for (File file : Objects.requireNonNull(root).listFiles()) {
            PropertiesUtils.loadPropsFromFile(file);
        }
    }

    private static void loadPropsFromFile(File file) {
        if (file.isDirectory()) {
            Arrays.stream(file.listFiles()).forEach(item -> PropertiesUtils.loadPropsFromFile(item));
            return;
        }
        if (file.getName().endsWith(".properties")) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                props.load(in);
            }
            catch (FileNotFoundException e) {
                log.debug("{}\u6587\u4ef6\u672a\u627e\u5230", (Object)file);
            }
            catch (IOException e) {
                log.debug("\u51fa\u73b0IOException", (Throwable)e);
            }
            finally {
                try {
                    if (null != in) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    log.debug("properties load \u51fa\u9519", (Throwable)e);
                }
            }
        }
    }

    public static String getProperty(String key) {
        if (null == props) {
            PropertiesUtils.loadProps();
        }
        return props.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        if (null == props) {
            PropertiesUtils.loadProps();
        }
        return props.getProperty(key, defaultValue);
    }
}

