/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Objects;
import org.hiylo.components.commons.utils.HttpClient;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.commons.vo.JuheRealNameAuthenticationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RealNameAuthentication {
    private static final Logger log = LoggerFactory.getLogger(RealNameAuthentication.class);
    @Value(value="${juhe.key: }")
    private String key;
    private String host = "http://op.juhe.cn/idcard/query";
    private HttpClient httpClient = new HttpClient();
    private Gson gson = new Gson();

    public boolean authentication(String realname, String cardcode) {
        if (StringUtils.isEmpty(this.key)) {
            throw new RuntimeException("Key should must be set");
        }
        try {
            String params = "?key={{key}}&idcard={{cardcode}}&realname={{realname}}";
            params = params.replace("{{key}}", this.key).replace("{{cardcode}}", cardcode).replace("{{realname}}", URLEncoder.encode(realname, "UTF-8"));
            String responseText = this.httpClient.get(this.host + params);
            log.debug(responseText == null ? "entity \u4e3a\u7a7a" : responseText);
            if (Objects.nonNull(responseText)) {
                JuheRealNameAuthenticationResponse response = (JuheRealNameAuthenticationResponse)this.gson.fromJson(responseText, JuheRealNameAuthenticationResponse.class);
                return Objects.nonNull(response) && Objects.nonNull(response.getResult()) && response.getResult().getRes() == 1;
            }
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

