/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowMail {
    private static Logger log = LoggerFactory.getLogger((String)ShowMail.class.getClass().getName());
    private MimeMessage mimeMessage = null;
    private String saveAttachPath = "";
    private StringBuffer bodyText = new StringBuffer();
    private String dateFormat = "yy-MM-dd HH:mm";

    public ShowMail() {
    }

    public ShowMail(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
        log.debug("\u521b\u5efa\u4e00\u4e2aReceiveEmail\u5bf9\u8c61....");
    }

    public static void main(String[] args) throws Exception {
        String host = "pop.qq.com";
        String username = "87411650";
        String password = "ellone";
        Properties props = new Properties();
        Session session = Session.getDefaultInstance((Properties)props, null);
        Store store = session.getStore("pop3");
        store.connect(host, username, password);
        Folder folder = store.getFolder("INBOX");
        folder.open(1);
        Message[] message = folder.getMessages();
        log.debug("\u90ae\u4ef6\u6570\u91cf:\u3000" + message.length);
        for (int i = 0; i < message.length; ++i) {
            ShowMail re = new ShowMail((MimeMessage)message[i]);
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u4e3b\u9898:\u3000" + re.getSubject());
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u53d1\u9001\u65f6\u95f4:\u3000" + re.getSentDate());
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u662f\u5426\u9700\u8981\u56de\u590d:\u3000" + re.getReplySign());
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u662f\u5426\u5df2\u8bfb:\u3000" + re.isNew());
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u662f\u5426\u5305\u542b\u9644\u4ef6:\u3000" + re.isContainAttach((Part)message[i]));
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u53d1\u9001\u4eba\u5730\u5740:\u3000" + re.getFrom());
            System.out.println("\u90ae\u4ef6\u3000" + i + "\u3000\u6536\u4fe1\u4eba\u5730\u5740:\u3000" + re.getMailAddress("to"));
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u6284\u9001:\u3000" + re.getMailAddress("cc"));
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u6697\u6284:\u3000" + re.getMailAddress("bcc"));
            re.setDateFormat("yy\u5e74MM\u6708dd\u65e5\u3000HH:mm");
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u53d1\u9001\u65f6\u95f4:\u3000" + re.getSentDate());
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u90ae\u4ef6ID:\u3000" + re.getMessageId());
            re.getMailContent((Part)message[i]);
            log.debug("\u90ae\u4ef6\u3000" + i + "\u3000\u6b63\u6587\u5185\u5bb9:\u3000\r\n" + re.getBodyText());
            re.setAttachPath("e:\\");
            re.saveAttachMent((Part)message[i]);
        }
    }

    public void setMimeMessage(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
        log.debug("\u8bbe\u7f6e\u4e00\u4e2aMimeMessage\u5bf9\u8c61...");
    }

    public String getFrom() throws Exception {
        String personal;
        InternetAddress[] address = (InternetAddress[])this.mimeMessage.getFrom();
        String from = address[0].getAddress();
        if (from == null) {
            from = "";
            log.debug("\u65e0\u6cd5\u77e5\u9053\u53d1\u9001\u8005.");
        }
        if ((personal = address[0].getPersonal()) == null) {
            personal = "";
            log.debug("\u65e0\u6cd5\u77e5\u9053\u53d1\u9001\u8005\u7684\u59d3\u540d.");
        }
        String fromAddr = null;
        if (Objects.nonNull(personal) || Objects.nonNull(from)) {
            fromAddr = personal + "<" + from + ">";
            log.debug("\u53d1\u9001\u8005\u662f\uff1a" + fromAddr);
        } else {
            log.debug("\u65e0\u6cd5\u83b7\u5f97\u53d1\u9001\u8005\u4fe1\u606f.");
        }
        return fromAddr;
    }

    public String getMailAddress(String type) throws Exception {
        StringBuilder mailAddr = new StringBuilder();
        String addType = type.toUpperCase();
        InternetAddress[] address = null;
        if ("TO".equals(addType) || "CC".equals(addType) || "BCC".equals(addType)) {
            address = "TO".equals(addType) ? (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.TO) : ("CC".equals(addType) ? (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.CC) : (InternetAddress[])this.mimeMessage.getRecipients(Message.RecipientType.BCC));
            if (Objects.nonNull(address)) {
                for (InternetAddress addres : address) {
                    String emailAddr = addres.getAddress();
                    if (emailAddr == null) {
                        emailAddr = "";
                    } else {
                        log.debug("\u8f6c\u6362\u4e4b\u524d\u7684emailAddr: " + emailAddr);
                        emailAddr = MimeUtility.decodeText((String)emailAddr);
                        log.debug("\u8f6c\u6362\u4e4b\u540e\u7684emailAddr: " + emailAddr);
                    }
                    String personal = addres.getPersonal();
                    if (personal == null) {
                        personal = "";
                    } else {
                        log.debug("\u8f6c\u6362\u4e4b\u524d\u7684personal: " + personal);
                        personal = MimeUtility.decodeText((String)personal);
                        log.debug("\u8f6c\u6362\u4e4b\u540e\u7684personal: " + personal);
                    }
                    String compositeto = personal + "<" + emailAddr + ">";
                    log.debug("\u5b8c\u6574\u7684\u90ae\u4ef6\u5730\u5740\uff1a" + compositeto);
                    mailAddr.append(",").append(compositeto);
                }
                mailAddr = new StringBuilder(mailAddr.substring(1));
            }
        } else {
            throw new Exception("\u9519\u8bef\u7684\u7535\u5b50\u90ae\u4ef6\u7c7b\u578b!");
        }
        return mailAddr.toString();
    }

    public String getSubject() {
        String subject = "";
        try {
            log.debug("\u8f6c\u6362\u524d\u7684subject\uff1a" + this.mimeMessage.getSubject());
            subject = MimeUtility.decodeText((String)this.mimeMessage.getSubject());
            log.debug("\u8f6c\u6362\u540e\u7684subject: " + this.mimeMessage.getSubject());
            if (subject == null) {
                subject = "";
            }
        }
        catch (Exception exce) {
            exce.printStackTrace();
        }
        return subject;
    }

    public String getSentDate() throws Exception {
        Date sentDate = this.mimeMessage.getSentDate();
        log.debug("\u53d1\u9001\u65e5\u671f \u539f\u59cb\u7c7b\u578b: " + this.dateFormat);
        SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
        String strSentDate = format.format(sentDate);
        log.debug("\u53d1\u9001\u65e5\u671f \u53ef\u8bfb\u7c7b\u578b: " + strSentDate);
        return strSentDate;
    }

    public String getBodyText() {
        return this.bodyText.toString();
    }

    public void getMailContent(Part part) throws Exception {
        String contentType = part.getContentType();
        log.debug("\u90ae\u4ef6\u7684MimeType\u7c7b\u578b: " + contentType);
        int nameIndex = contentType.indexOf("name");
        boolean conName = false;
        if (nameIndex != -1) {
            conName = true;
        }
        log.debug("\u90ae\u4ef6\u5185\u5bb9\u7684\u7c7b\u578b:\u3000" + contentType);
        if (part.isMimeType("text/plain") && !conName) {
            this.bodyText.append((String)part.getContent());
        } else if (part.isMimeType("text/html") && !conName) {
            this.bodyText.append((String)part.getContent());
        } else if (part.isMimeType("multipart/*")) {
            Multipart multipart = (Multipart)part.getContent();
            int counts = multipart.getCount();
            for (int i = 0; i < counts; ++i) {
                this.getMailContent((Part)multipart.getBodyPart(i));
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.getMailContent((Part)part.getContent());
        }
    }

    public boolean getReplySign() throws MessagingException {
        boolean replySign = false;
        String[] needReply = this.mimeMessage.getHeader("Disposition-Notification-To");
        if (Objects.nonNull(needReply)) {
            replySign = true;
        }
        if (replySign) {
            log.debug("\u8be5\u90ae\u4ef6\u9700\u8981\u56de\u590d");
        } else {
            log.debug("\u8be5\u90ae\u4ef6\u4e0d\u9700\u8981\u56de\u590d");
        }
        return replySign;
    }

    public String getMessageId() throws MessagingException {
        String messageID = this.mimeMessage.getMessageID();
        log.debug("\u90ae\u4ef6ID: " + messageID);
        return messageID;
    }

    public boolean isNew() throws MessagingException {
        boolean isNew = false;
        Flags flags = this.mimeMessage.getFlags();
        Flags.Flag[] flag = flags.getSystemFlags();
        log.debug("flags\u7684\u957f\u5ea6:\u3000" + flag.length);
        for (Flags.Flag aFlag : flag) {
            if (aFlag != Flags.Flag.SEEN) continue;
            isNew = true;
            log.debug("seen email...");
        }
        return isNew;
    }

    public boolean isContainAttach(Part part) throws Exception {
        boolean attachFlag = false;
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart mPart = mp.getBodyPart(i);
                String disposition = mPart.getDisposition();
                if (Objects.nonNull(disposition) && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    attachFlag = true;
                    continue;
                }
                if (mPart.isMimeType("multipart/*")) {
                    attachFlag = this.isContainAttach((Part)mPart);
                    continue;
                }
                String conType = mPart.getContentType();
                if (conType.toLowerCase().contains("application")) {
                    attachFlag = true;
                }
                if (!conType.toLowerCase().contains("name")) continue;
                attachFlag = true;
            }
        } else if (part.isMimeType("message/rfc822")) {
            attachFlag = this.isContainAttach((Part)part.getContent());
        }
        return attachFlag;
    }

    public void saveAttachMent(Part part) throws Exception {
        String fileName = "";
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart mPart = mp.getBodyPart(i);
                String disposition = mPart.getDisposition();
                if (Objects.nonNull(disposition) && (disposition.equals("attachment") || disposition.equals("inline"))) {
                    fileName = mPart.getFileName();
                    if (fileName.toLowerCase().contains("gb2312")) {
                        fileName = MimeUtility.decodeText((String)fileName);
                    }
                    this.saveFile(fileName, mPart.getInputStream());
                    continue;
                }
                if (mPart.isMimeType("multipart/*")) {
                    this.saveAttachMent((Part)mPart);
                    continue;
                }
                fileName = mPart.getFileName();
                if (!Objects.nonNull(fileName) || !fileName.toLowerCase().contains("GB2312")) continue;
                fileName = MimeUtility.decodeText((String)fileName);
                this.saveFile(fileName, mPart.getInputStream());
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.saveAttachMent((Part)part.getContent());
        }
    }

    public void setDateFormat(String format) {
        this.dateFormat = format;
    }

    public String getAttachPath() {
        return this.saveAttachPath;
    }

    public void setAttachPath(String attachPath) {
        this.saveAttachPath = attachPath;
    }

    private void saveFile(String fileName, InputStream in) throws Exception {
        String osName = System.getProperty("os.name");
        String storeDir = this.getAttachPath();
        String separator = "";
        if (osName == null) {
            osName = "";
        }
        if (osName.toLowerCase().contains("win")) {
            separator = "\\";
            if (storeDir == null || "".equals(storeDir)) {
                storeDir = "c:\\tmp";
            }
        } else {
            separator = "/";
            storeDir = "/tmp";
        }
        File storeFile = new File(storeDir + separator + fileName);
        log.debug("\u9644\u4ef6\u7684\u4fdd\u5b58\u5730\u5740:\u3000" + storeFile.toString());
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(storeFile));
             BufferedInputStream bis = new BufferedInputStream(in);){
            int c;
            while ((c = bis.read()) != -1) {
                bos.write(c);
                bos.flush();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Exception("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25!");
        }
    }
}

