/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

public class TimeUtils {
    private static final int SECOND_OF_YEAR = 31536000;
    private static final int SECOND_OF_MONTH = 2592000;
    private static final int SECOND_OF_DAY = 86400;
    private static final int SECOND_OF_HOUR = 3600;
    private static final int SECOND_OF_MINUTE = 60;

    public final String parseSecond(int seconds) {
        StringBuilder result = new StringBuilder();
        if (seconds / 31536000 > 0) {
            result.append(seconds / 31536000).append("\u5e74");
        }
        if ((seconds %= 31536000) / 2592000 > 0) {
            result.append(seconds / 2592000).append("\u6708");
        }
        if ((seconds %= 2592000) / 86400 > 0) {
            result.append(seconds / 86400).append("\u5929");
        }
        if ((seconds %= 86400) / 3600 > 0) {
            result.append(seconds / 3600).append("\u5c0f\u65f6");
        }
        if ((seconds %= 3600) / 60 > 0 || seconds % 60 > 0) {
            result.append(seconds / 60 + (seconds % 60 > 0 ? 1 : 0)).append("\u5206");
        }
        return result.toString();
    }
}

