/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hiylo.components.commons.utils.NumberUtils;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ValidateUtils {
    private static Logger log = LoggerFactory.getLogger((String)ValidateUtils.class.getClass().getName());

    public static boolean isNotEmpty(String ... values) {
        return StringUtils.isNotEmpty(values);
    }

    public static boolean greaterZore(Integer ... values) {
        AtomicBoolean hasNull = new AtomicBoolean(false);
        int[] temp = new int[values.length];
        int[] index = new int[]{0};
        Arrays.stream(values).forEach(item -> {
            if (!Objects.nonNull(item)) {
                hasNull.set(true);
                return;
            }
            temp[index[0]] = item;
            index[0] = index[0] + 1;
        });
        if (hasNull.get()) {
            return false;
        }
        return NumberUtils.greaterThanZero(temp);
    }

    public static List<ObjectError> process(BindingResult bindingResult, String ... fields) {
        ArrayList<ObjectError> objectErrors = new ArrayList<ObjectError>(10);
        Arrays.stream(fields).forEach(f -> objectErrors.addAll(bindingResult.getFieldErrors(f)));
        return objectErrors;
    }

    public static void validate(BindingResult bindingResult, String ... fields) {
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        Arrays.stream(fields).forEach(f -> bindingResult.getFieldErrors(f).forEach(fieldError -> {
            log.warn("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)(fieldError.getField() + ":" + fieldError.getDefaultMessage()));
            isSuccess.set(false);
        }));
        if (!isSuccess.get()) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public static void validate(BindingResult bindingResult) {
        boolean isSuccess;
        boolean bl = isSuccess = bindingResult.getErrorCount() <= 0;
        if (!isSuccess) {
            log.warn("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", bindingResult.getAllErrors().toArray());
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }

    public static void validateExclude(BindingResult bindingResult, String ... fields) {
        List<String> strings = Arrays.asList(fields);
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        String[] suppressedFields = bindingResult.getSuppressedFields();
        suppressedFields = (String[])Arrays.stream(suppressedFields).filter(item -> !strings.contains(item)).toArray(String[]::new);
        Arrays.stream(suppressedFields).forEach(field -> {
            FieldError error = bindingResult.getFieldError(field);
            log.warn("\u53c2\u6570\u6821\u9a8c\u5931\u8d25: {}", (Object)(error.getObjectName() + ":" + error.getDefaultMessage()));
            isSuccess.set(false);
        });
        if (!isSuccess.get()) {
            throw CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_EINVAL);
        }
    }
}

