/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.commons.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Zip {
    private static final Logger log = LoggerFactory.getLogger(Zip.class);

    public void compress(String outputFolder, File inputFile) throws Exception {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFolder));
        BufferedOutputStream bo = new BufferedOutputStream(out);
        this.compress(out, inputFile, inputFile.getName(), bo);
        bo.close();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compress(ZipOutputStream out, File f, String base, BufferedOutputStream bo) {
        FileInputStream in = null;
        BufferedInputStream bi = null;
        try {
            if (f.isDirectory()) {
                File[] fl = f.listFiles();
                if (fl == null || fl.length == 0) {
                    out.putNextEntry(new ZipEntry(base + "/"));
                }
                for (int i = 0; Objects.nonNull(fl) && i < fl.length; ++i) {
                    this.compress(out, fl[i], base + "/" + fl[i].getName(), bo);
                }
            } else {
                int b;
                out.putNextEntry(new ZipEntry(base));
                in = new FileInputStream(f);
                bi = new BufferedInputStream(in);
                while ((b = bi.read()) != -1) {
                    bo.write(b);
                }
            }
        }
        catch (IOException e) {
            log.error("\u538b\u7f29", (Throwable)e);
        }
        finally {
            try {
                if (Objects.nonNull(bi)) {
                    bi.close();
                }
                if (Objects.nonNull(in)) {
                    in.close();
                }
            }
            catch (IOException e) {
                log.error("\u538b\u7f29", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncompress(String inputFile, String outputFolder) {
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            ZipEntry entry;
            zipInputStream = new ZipInputStream(new FileInputStream(inputFile));
            bufferedInputStream = new BufferedInputStream(zipInputStream);
            String parent = outputFolder;
            while (Objects.nonNull(entry = zipInputStream.getNextEntry()) && !entry.isDirectory()) {
                FileOutputStream fileOutputStream = null;
                FilterOutputStream bufferedOutputStream = null;
                try {
                    int b;
                    File outFile = new File(parent, entry.getName());
                    if (!outFile.exists() && !new File(outFile.getParent()).mkdirs()) {
                        return;
                    }
                    fileOutputStream = new FileOutputStream(outFile);
                    bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    while ((b = bufferedInputStream.read()) != -1) {
                        ((BufferedOutputStream)bufferedOutputStream).write(b);
                    }
                }
                catch (IOException e) {
                    log.error("\u89e3\u538b", (Throwable)e);
                }
                finally {
                    if (Objects.nonNull(bufferedOutputStream)) {
                        bufferedOutputStream.close();
                    }
                    if (!Objects.nonNull(fileOutputStream)) continue;
                    fileOutputStream.close();
                }
            }
        }
        catch (IOException e) {
            log.error("\u89e3\u538b", (Throwable)e);
        }
        finally {
            try {
                if (Objects.nonNull(bufferedInputStream)) {
                    bufferedInputStream.close();
                }
                if (Objects.nonNull(zipInputStream)) {
                    zipInputStream.close();
                }
            }
            catch (IOException e) {
                log.error("\u89e3\u538b", (Throwable)e);
            }
        }
    }
}

