/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.exceptions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hiylo.components.exceptions.Constants;

public class BaseException
extends Exception
implements Serializable {
    private static final long serialVersionUID = 2543258395234000337L;
    private Integer code;
    private Class clazz;

    public BaseException(Integer code) {
        this(code, Constants.ExceptionDescript.get(code), BaseException.class);
    }

    public BaseException(Integer code, String message) {
        this(code, message, BaseException.class);
    }

    public BaseException(Integer code, String message, Class clazz) {
        super("{\"retCode\":\"" + code + "\",\"retObject\":\"" + message + "\",\"clazz\":\"" + clazz.getName() + "\"}");
        this.setCode(code);
        this.clazz = clazz;
    }

    public static <T extends BaseException> T call(Integer code) {
        StackTraceElement[] elements;
        for (StackTraceElement ele : elements = new Throwable().getStackTrace()) {
            try {
                if (Class.forName(ele.getClassName()).getSuperclass() != BaseException.class) continue;
                Constructor<?> constructor = Class.forName(ele.getClassName()).getConstructor(Integer.class, String.class);
                BaseException t = (BaseException)constructor.newInstance(code, Constants.ExceptionDescript.get(code));
                return (T)t;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T extends BaseException> T call(Integer code, String message) {
        StackTraceElement[] elements;
        for (StackTraceElement ele : elements = new Throwable().getStackTrace()) {
            try {
                if (Class.forName(ele.getClassName()).getSuperclass() != BaseException.class) continue;
                Constructor<?> constructor = Class.forName(ele.getClassName()).getConstructor(Integer.class, String.class);
                return (T)((BaseException)constructor.newInstance(code, message));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}

