/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.exceptions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hiylo.components.exceptions.BaseException;
import org.hiylo.components.exceptions.Constants;

public class BaseRuntimeException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = 2543258395234000337L;
    private Integer code;

    public BaseRuntimeException(Integer code) {
        this(code, Constants.ExceptionDescript.get(code), BaseException.class);
    }

    public BaseRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public BaseRuntimeException(Integer code, String message) {
        this(code, message, BaseRuntimeException.class);
    }

    public BaseRuntimeException(Integer code, String message, Class clazz) {
        super("{\"retCode\":\"" + code + "\",\"retObject\":\"" + message + "\",\"clazz\":\"" + clazz.getName() + "\"}");
        this.setCode(code);
    }

    public static <T extends BaseRuntimeException> T call(Integer code) {
        StackTraceElement[] elements;
        for (StackTraceElement ele : elements = new Throwable().getStackTrace()) {
            try {
                if (Class.forName(ele.getClassName()).getSuperclass() != BaseRuntimeException.class) continue;
                Constructor<?> constructor = Class.forName(ele.getClassName()).getConstructor(Integer.class, String.class);
                return (T)((BaseRuntimeException)constructor.newInstance(code, Constants.ExceptionDescript.get(code)));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static <T extends BaseRuntimeException> T call(Integer code, String message) {
        StackTraceElement[] elements;
        for (StackTraceElement ele : elements = new Throwable().getStackTrace()) {
            try {
                if (Class.forName(ele.getClassName()).getSuperclass() != BaseRuntimeException.class) continue;
                Constructor<?> constructor = Class.forName(ele.getClassName()).getConstructor(Integer.class, String.class);
                return (T)((BaseRuntimeException)constructor.newInstance(code, message));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }
}

