/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.exceptions.config;

import io.sentry.Sentry;
import io.sentry.SentryClient;
import io.sentry.spring.SentryExceptionResolver;
import io.sentry.spring.SentryServletContextInitializer;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerExceptionResolver;

@Configuration
@ConditionalOnProperty(name={"sentry.enable"}, havingValue="true")
public class SentryConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SentryConfiguration.class);
    @Value(value="${spring.profiles.active}")
    private String profile;
    @Value(value="${eureka.instance.metadataMap.version:1.0.0}")
    private String version;
    @Value(value="${spring.application.name:hiylo}")
    private String applicationName;
    @Value(value="${sentry.dsn}")
    private String sentryDsn;
    @Value(value="${sentry.sample.rate:0.75}")
    private String sampleRate;
    @Value(value="${sentry.stacktrace.app.packages:org.hiylo,org.springframework,org.hibernate}")
    private String packages;

    @PostConstruct
    public void init() {
        System.setProperty("SENTRY_STACKTRACE_APP_PACKAGES", this.packages);
        System.setProperty("stacktrace.app.packages", this.packages);
        System.setProperty("SENTRY_SAMPLE_RATE", this.sampleRate);
        SentryClient sentryClient = Sentry.init((String)this.sentryDsn);
        sentryClient.setEnvironment(this.profile);
        sentryClient.setRelease(this.version);
        sentryClient.setServerName(this.applicationName);
        log.debug("sentry started!");
    }

    @Bean
    public ServletContextInitializer sentryServletContextInitializer() {
        return new SentryServletContextInitializer();
    }

    @Bean
    public HandlerExceptionResolver sentryExceptionResolver() {
        return new SentryExceptionResolver();
    }
}

