/*
 * Copyright(c) 2016 - 2020, Clouds Studio Holding Limited. All rights reserved.
 * Project : components
 * File : SingletonSequence.java
 * Date : 7/22/20, 12:51 AM
 * Author : Hsi Chu
 * Contact : hiylo@live.com
 */

package org.hiylo.components.sequence;

import java.util.concurrent.ThreadLocalRandom;

/**
 * 单机版Snowflake算法
 *
 * @author hiylo
 * @date 2018年2月13日 02:22:51
 */
public class SingletonSequence extends AbstractSequence {

    /**
     * 工作机器ID(0~31)
     */
    private int workerId = 0;
    /**
     * 数据中心ID(0~31)
     */
    private int datacenterId = 0;
    /**
     * 毫秒内序列(0~4095)
     */
    private long sequence = 0L;

    public SingletonSequence() {

    }

    public SingletonSequence(int datacenterId, int workerId) {
        this.datacenterId = datacenterId;
        this.workerId = workerId;
    }

    /**
     * 获得下一个ID (该方法是线程安全的)
     *
     * @return
     */
    @Override
    public synchronized String nextIdString() {
        long timestamp = timeGen();
        //$NON-NLS-解决跨毫秒生成ID序列号始终为偶数的缺陷$
        // 如果是同一时间生成的，则进行毫秒内序列
        if (lastTimestamp == timestamp) {
            sequence = (sequence + 1) & sequenceMask;
            // 毫秒内序列溢出
            if (sequence == 0) {
                // 阻塞到下一个毫秒,获得新的时间戳
                timestamp = tilNextMillis(lastTimestamp);
            }
        } else {// 时间戳改变，毫秒内序列重置
            sequence = 0L;
        }
        // 如果是同一时间生成的，则进行毫秒内序列
        if (lastTimestamp == timestamp) {
            long old = sequence;
            sequence = (sequence + 1) & sequenceMask;
            // 毫秒内序列溢出
            if (sequence == old) {
                // 阻塞到下一个毫秒,获得新的时间戳
                timestamp = tilNextMillis(lastTimestamp);
            }
        } else {// 时间戳改变，毫秒内序列重置
            sequence = ThreadLocalRandom.current().nextLong(0, 2);
        }

        /**
         * 上次生成ID的时间截
         **/
        lastTimestamp = timestamp;

        // 移位并通过或运算拼到一起组成64位的ID
//		return (((timestamp - twepoch) << timestampLeftShift) //
//				| (datacenterId << datacenterIdShift) //
//				| (workerId << workerIdShift) //
//				| sequence);
        return "0-" + ((timestamp - twepoch) << timestampLeftShift) + "-" +
                (datacenterId << datacenterIdShift) + "-" +
                (workerId << workerIdShift) + "-" +
                sequence;
    }

    /**
     * 获得下一个ID (该方法是线程安全的)
     *
     * @return
     */
    @Override
    public synchronized long nextId() {
        long timestamp = timeGen();
        //$NON-NLS-解决跨毫秒生成ID序列号始终为偶数的缺陷$
        // 如果是同一时间生成的，则进行毫秒内序列
        if (lastTimestamp == timestamp) {
            sequence = (sequence + 1) & sequenceMask;
            // 毫秒内序列溢出
            if (sequence == 0) {
                // 阻塞到下一个毫秒,获得新的时间戳
                timestamp = tilNextMillis(lastTimestamp);
            }
        } else {// 时间戳改变，毫秒内序列重置
            sequence = 0L;
        }
        // 如果是同一时间生成的，则进行毫秒内序列
        if (lastTimestamp == timestamp) {
            long old = sequence;
            sequence = (sequence + 1) & sequenceMask;
            // 毫秒内序列溢出
            if (sequence == old) {
                // 阻塞到下一个毫秒,获得新的时间戳
                timestamp = tilNextMillis(lastTimestamp);
            }
        } else {// 时间戳改变，毫秒内序列重置
            sequence = ThreadLocalRandom.current().nextLong(0, 2);
        }

        // 上次生成ID的时间截
        lastTimestamp = timestamp;

        // 移位并通过或运算拼到一起组成64位的ID
        return (((timestamp - twepoch) << timestampLeftShift)
                | (datacenterId << datacenterIdShift)
                | (workerId << workerIdShift)
                | sequence);
    }
}
