/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.sequence;

import org.hiylo.components.sequence.SystemClock;

public abstract class AbstractSequence {
    final long twepoch = 1288834974657L;
    final long workerIdBits = 5L;
    final long datacenterIdBits = 5L;
    final long maxWorkerId = 31L;
    final long maxDatacenterId = 31L;
    final long sequenceBits = 12L;
    final long workerIdShift = 12L;
    final long datacenterIdShift = 17L;
    final long timestampLeftShift = 22L;
    final long sequenceMask = 4095L;
    protected long lastTimestamp = -1L;

    public abstract String nextIdString();

    public abstract long nextId();

    protected boolean checkLastTimestamp(long timestamp) {
        block5: {
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        return true;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return SystemClock.now();
    }
}

