/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.sequence;

import java.util.List;
import javax.annotation.PostConstruct;
import org.hiylo.components.sequence.AbstractSequence;
import org.hiylo.components.sequence.SingletonSequence;
import org.hiylo.components.zookeeper.I0ItecZooKeeperServiceProvider;
import org.springframework.beans.factory.annotation.Autowired;

public class DistributedSequence
extends AbstractSequence {
    @Autowired
    private I0ItecZooKeeperServiceProvider zooKeeperServiceProvider;
    private int workerId = 0;
    private int datacenterId = 0;
    private long sequence = 0L;
    private SingletonSequence singletonSequence;

    @PostConstruct
    public void init() {
        try {
            List datacenterIds = this.zooKeeperServiceProvider.get("/config/sequence/");
            int i = 0;
            while ((long)i <= 31L) {
                if (datacenterIds.contains(String.valueOf(i))) {
                    List workIds = this.zooKeeperServiceProvider.get("/config/sequence/" + i + "/worker/");
                    int j = 0;
                    while ((long)j <= 31L) {
                        if (!workIds.contains(String.valueOf(i))) {
                            this.workerId = i;
                            this.datacenterId = i;
                            this.zooKeeperServiceProvider.put("/config/sequence/" + i + "/worker/", String.valueOf(i));
                            this.singletonSequence = new SingletonSequence(this.datacenterId, this.workerId);
                            return;
                        }
                        ++j;
                    }
                } else {
                    this.workerId = i;
                    this.datacenterId = 0;
                    this.zooKeeperServiceProvider.put("/config/sequence/" + i + "/worker/", String.valueOf(0));
                    this.singletonSequence = new SingletonSequence(this.datacenterId, this.workerId);
                    return;
                }
                ++i;
            }
        }
        catch (RuntimeException e) {
            this.zooKeeperServiceProvider.put("/config/sequence/0/worker/", "0");
            this.workerId = 0;
            this.datacenterId = 0;
            this.singletonSequence = new SingletonSequence(this.datacenterId, this.workerId);
            return;
        }
        throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
    }

    @Override
    public synchronized String nextIdString() {
        return this.singletonSequence.nextIdString();
    }

    @Override
    public synchronized long nextId() {
        return this.singletonSequence.nextId();
    }
}

