/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.hiylo.components.commons.utils.HttpClient;
import org.hiylo.components.fentity.vo.ReturnVO;
import org.hiylo.components.fentity.vo.menu.Button;
import org.hiylo.components.fentity.vo.menu.ComplexButton;
import org.hiylo.components.fentity.vo.menu.Menu;
import org.hiylo.components.fentity.vo.menu.ViewButton;
import org.hiylo.components.wechat.WechatPublicAccountConstants;
import org.hiylo.components.wechat.config.WechatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MenuManager {
    private static Logger log = LoggerFactory.getLogger(MenuManager.class);
    @Autowired
    private WechatConfig wxAppPayConfig;
    private HttpClient httpClient = new HttpClient();
    @Autowired
    public WechatPublicAccountConstants constants;
    private Gson gson = new Gson();

    public Menu createMenu(String baseUrl) throws UnsupportedEncodingException {
        ViewButton btn13 = new ViewButton();
        btn13.setName("\u9996\u9875");
        btn13.setType("view");
        btn13.setUrl(baseUrl + "/produce/index");
        ViewButton btn21 = new ViewButton();
        btn21.setName("\u6211\u7684\u8d2d\u7269\u8f66");
        btn21.setType("view");
        btn21.setUrl(this.constants.getUserAuthorizationUrl(URLEncoder.encode(baseUrl + "/order/list", "UTF-8")));
        ViewButton btn31 = new ViewButton();
        btn31.setType("view");
        btn31.setName("\u6dfb\u52a0\u7528\u6237");
        btn31.setUrl(this.constants.getUserAuthorizationUrl(URLEncoder.encode(baseUrl + "/member/toAddUser", "UTF-8")));
        ViewButton btn32 = new ViewButton();
        btn32.setName("\u6fc0\u6d3b\u7528\u6237");
        btn32.setType("view");
        btn32.setUrl(this.constants.getUserAuthorizationTokenUrl(URLEncoder.encode(baseUrl + "/member/toActiveUser", "UTF-8")));
        ViewButton btn33 = new ViewButton();
        btn33.setName("\u79ef\u5206\u4e2d\u5fc3");
        btn33.setType("view");
        btn33.setUrl(this.constants.getUserAuthorizationUrl(URLEncoder.encode(baseUrl + "/member/toPointRecord", "UTF-8")));
        ComplexButton mainBtn1 = new ComplexButton();
        mainBtn1.setName("\u6211\u7684\u5546\u57ce");
        mainBtn1.setSub_button(new Button[]{btn13});
        ComplexButton mainBtn2 = new ComplexButton();
        mainBtn2.setName("\u8d2d\u7269\u8f66");
        mainBtn2.setSub_button(new Button[]{btn21});
        ComplexButton mainBtn3 = new ComplexButton();
        mainBtn3.setName("\u4e2a\u4eba\u4e2d\u5fc3");
        mainBtn3.setSub_button(new Button[]{btn31, btn32, btn33});
        Menu menu = new Menu();
        menu.setButton(new Button[]{mainBtn1, mainBtn2, mainBtn3});
        return menu;
    }

    public boolean createMenu(Menu menu, String accessToken) {
        String jsonMenu = JSONObject.fromObject((Object)menu).toString();
        String requestUrl = this.constants.createMenu(accessToken);
        String jsonObject = this.httpClient.httpsRequest(requestUrl, "POST", jsonMenu);
        return Objects.nonNull(jsonObject) && ((ReturnVO)this.gson.fromJson(jsonObject, ReturnVO.class)).getErrcode() == 0;
    }

    public String getMenu(String accessToken) {
        String result = null;
        String requestUrl = this.constants.getMenu(accessToken);
        String jsonObject = this.httpClient.httpsRequest(requestUrl, "GET", null);
        if (Objects.nonNull(jsonObject)) {
            result = jsonObject;
        }
        return result;
    }

    public boolean deleteMenu(String accessToken) {
        String requestUrl = this.constants.deleteMenu(accessToken);
        String jsonObject = this.httpClient.httpsRequest(requestUrl, "GET", null);
        return Objects.nonNull(jsonObject) && ((ReturnVO)this.gson.fromJson(jsonObject, ReturnVO.class)).getErrcode() == 0;
    }
}

