/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.hiylo.components.wechat.config.WechatConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WechatPublicAccountConstants
implements Serializable {
    private static final long serialVersionUID = -1L;
    private WechatConfig wechatConfig;

    @Autowired
    public WechatPublicAccountConstants(WechatConfig wechatConfig) {
        this.wechatConfig = wechatConfig;
    }

    public String getUserAuthorizationUrl(String url) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        try {
            return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APP_ID&redirect_uri=REDIRECT_URI&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect".replace("REDIRECT_URI", URLEncoder.encode(url, "UTF-8")).replace("APP_ID", this.wechatConfig.getAppID());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public String getJsTicketUrl(String accessToken) {
        return "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi".replace("ACCESS_TOKEN", accessToken);
    }

    public String getUserAuthorizationTokenUrl(String code) {
        return "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APP_ID&secret=SECRET&code=CODE&grant_type=authorization_code".replace("CODE", code).replace("APP_ID", this.wechatConfig.getAppID()).replace("SECRET", this.wechatConfig.getAppsecret());
    }

    public String getGrantClientCredentialTokenUrl() {
        return "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APP_ID&secret=SECRET".replace("APP_ID", this.wechatConfig.getAppID()).replace("SECRET", this.wechatConfig.getAppsecret());
    }

    public String getUserInfoUrl(String accessToken, String openId) {
        return "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN".replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId);
    }

    public String getMenu(String accessToken) {
        return "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=ACCESS_TOKEN".replace("ACCESS_TOKEN", accessToken);
    }

    public String deleteMenu(String accessToken) {
        return "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=ACCESS_TOKEN".replace("ACCESS_TOKEN", accessToken);
    }

    public String createMenu(String accessToken) {
        return "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=ACCESS_TOKEN".replace("ACCESS_TOKEN", accessToken);
    }

    public WechatConfig getWechatConfig() {
        return this.wechatConfig;
    }

    public class Request
    implements Serializable {
        private static final long serialVersionUID = -1L;
        private static final String CREATE_MENU = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=ACCESS_TOKEN";
        private static final String GET_MENU = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=ACCESS_TOKEN";
        private static final String DELETE_MENU = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=ACCESS_TOKEN";
        private static final String GRANT_CLIENT_CREDENTIAL_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APP_ID&secret=SECRET";
        private static final String GRANT_USER_AUTHORIZATION_TOKEN = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APP_ID&secret=SECRET&code=CODE&grant_type=authorization_code";
        private static final String GET_USER_AUTHORIZATION = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APP_ID&redirect_uri=REDIRECT_URI&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect";
        private static final String GET_USER_INFO = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
        private static final String GET_JSAPI_TOKEN = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";
    }

    public class RequestMessageType
    implements Serializable {
        private static final long serialVersionUID = -1L;
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_TEXT = "text";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_IMAGE = "image";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_VOICE = "voice";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_VIDEO = "video";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_LOCATION = "location";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_LINK = "link";
        public static final String WEIXIN_REQUEST_MESSAGE_TYPE_EVENT = "event";
        public static final String WEIXIN_EVENT_TYPE_SUBSCRIBE = "subscribe";
        public static final String WEIXIN_EVENT_TYPE_UNSUBSCRIBE = "unsubscribe";
        public static final String WEIXIN_EVENT_TYPE_SCAN = "SCAN";
        public static final String WEIXIN_EVENT_TYPE_LOCATION = "LOCATION";
        public static final String WEIXIN_EVENT_TYPE_CLICK = "CLICK";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_TEXT = "text";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_IMAGE = "image";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_VOICE = "voice";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_VIDEO = "video";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_MUSIC = "music";
        public static final String WEIXIN_RESPONSE_MESSAGE_TYPE_NEWS = "news";
    }
}

