/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.config;

import com.github.wxpay.sdk.WXPayConfig;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.CommonsException;
import org.hiylo.components.exceptions.CommonsRuntimeException;
import org.hiylo.components.exceptions.Constants;
import org.hiylo.components.wechat.pay.IWechatPayDomain;
import org.hiylo.components.wechat.pay.WechatPayDomainSimpleImpl;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.ResourceUtils;

@ConfigurationProperties(prefix="wechat", ignoreInvalidFields=false)
public class WechatConfig
implements Serializable,
WXPayConfig {
    public static final String EXCEPTION_CODE_PAYMENT_TOTAL_FEE_CANT_BE_ZERO = "0x10700001";
    public static final String EXCEPTION_CODE_PAYMENT_REQUEST_THIRD_PART_FAIL = "0x10700002";
    private static final Integer DEFAULT_REPORT_WORKER_NUM = 6;
    private static final Integer DEFAULT_REPORT_BATCH_SIZE = 10;
    private static final Integer DEFAULT_REPORT_QUEUE_MAX_SIZE = 10000;
    private static final long serialVersionUID = -1L;
    private String certPath;
    private byte[] certData;
    private String appID;
    private String appsecret;
    private String partner;
    private String partnerkey;
    private Map<String, String> properties;

    public WechatConfig() {
        this.properties = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WechatConfig(String configFile) throws IOException, CommonsException {
        block6: {
            this.properties = new HashMap<String, String>();
            Properties properties = new Properties();
            InputStream inputStream = WechatConfig.class.getClassLoader().getResourceAsStream(configFile);
            try {
                if (Objects.nonNull(inputStream) && inputStream.available() != -1) {
                    properties.load(inputStream);
                    this.appID = properties.getProperty("wechat.appID");
                    this.appsecret = properties.getProperty("wechat.appsecret");
                    this.partner = properties.getProperty("wechat.partner");
                    this.partnerkey = properties.getProperty("wechat.partnerkey");
                    if (StringUtils.isEmpty((String[])new String[]{this.appID, this.appsecret, this.partner, this.partnerkey})) {
                        throw (CommonsException)CommonsException.buildException((Integer)Constants.EXCEPTION_CODE_CONFIG_PROPERTY_MISSING);
                    }
                    this.init();
                    break block6;
                }
                throw new IOException("Config file is not available! Please provider a available config file!");
            }
            finally {
                if (Objects.nonNull(inputStream)) {
                    inputStream.close();
                }
            }
        }
    }

    public WechatConfig(String appID, String appsecret, String partner, String partnerkey) {
        this.properties = new HashMap<String, String>();
        this.appID = appID;
        this.appsecret = appsecret;
        this.partner = partner;
        this.partnerkey = partnerkey;
        this.init();
    }

    public WechatConfig(String appID, String appsecret, String partner, String partnerkey, byte[] certData) {
        this.properties = new HashMap<String, String>();
        this.appID = appID;
        this.appsecret = appsecret;
        this.partner = partner;
        this.partnerkey = partnerkey;
        this.certData = certData;
        this.init();
    }

    public static void main(String[] args) {
    }

    @PostConstruct
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCertPath(String certPath) throws IOException {
        this.certPath = certPath;
        InputStream certStream = null;
        try {
            try {
                File file = new File(ResourceUtils.getURL((String)certPath).getFile());
                certStream = ResourceUtils.getURL((String)certPath).openStream();
                this.certData = new byte[(int)file.length()];
                int length = certStream.read(this.certData);
                if ((long)length != file.length()) {
                    throw (CommonsRuntimeException)CommonsRuntimeException.buildException((Integer)Constants.EXCEPTION_CODE_UNKNOWN_ERROR);
                }
            }
            finally {
                Optional.ofNullable(certStream).ifPresent(inputStream -> {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getAppID() {
        return this.appID;
    }

    public String getMchID() {
        return this.partner;
    }

    public String getKey() {
        return this.partnerkey;
    }

    public InputStream getCertStream() {
        return new ByteArrayInputStream(this.certData);
    }

    public int getHttpConnectTimeoutMs() {
        return 10000;
    }

    public int getHttpReadTimeoutMs() {
        return 10000;
    }

    public IWechatPayDomain getWechatPayDomain() {
        return new WechatPayDomainSimpleImpl();
    }

    public String toString() {
        return "WechatAppPayConfig{certPath='" + this.certPath + '\'' + ", certData=" + Arrays.toString(this.certData) + ", appID='" + this.appID + '\'' + ", appsecret='" + this.appsecret + '\'' + ", partner='" + this.partner + '\'' + ", partnerkey='" + this.partnerkey + '\'' + ", properties=" + this.properties + '}';
    }

    public String getCertPath() {
        return this.certPath;
    }

    public byte[] getCertData() {
        return this.certData;
    }

    public void setCertData(byte[] certData) {
        this.certData = certData;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getAppsecret() {
        return this.appsecret;
    }

    public void setAppsecret(String appsecret) {
        this.appsecret = appsecret;
    }

    public String getPartner() {
        return this.partner;
    }

    public void setPartner(String partner) {
        this.partner = partner;
    }

    public String getPartnerkey() {
        return this.partnerkey;
    }

    public void setPartnerkey(String partnerkey) {
        this.partnerkey = partnerkey;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean shouldAutoReport() {
        return true;
    }

    public int getReportWorkerNum() {
        return DEFAULT_REPORT_WORKER_NUM;
    }

    public int getReportQueueMaxSize() {
        return DEFAULT_REPORT_QUEUE_MAX_SIZE;
    }

    public int getReportBatchSize() {
        return DEFAULT_REPORT_BATCH_SIZE;
    }
}

