/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.miniprogram.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import org.hiylo.components.commons.utils.HttpClient;
import org.hiylo.components.fentity.vo.WechatMiniProgramToken;
import org.hiylo.components.wechat.WechatMiniProgramConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WechatMiniProgramUtils {
    private static final Logger log = LoggerFactory.getLogger(WechatMiniProgramUtils.class);
    private HttpClient httpClient = new HttpClient();
    private Gson gson = new Gson();
    private WechatMiniProgramConstants wechatMiniProgramConstants;

    @Autowired
    public WechatMiniProgramUtils(WechatMiniProgramConstants wechatMiniProgramConstants) {
        this.wechatMiniProgramConstants = wechatMiniProgramConstants;
    }

    public WechatMiniProgramToken getUserToken(String code) {
        try {
            String result = this.httpClient.get(this.wechatMiniProgramConstants.getUserAuthorizationTokenUrl(code));
            log.info(result);
            return (WechatMiniProgramToken)this.gson.fromJson(result, TypeToken.get(WechatMiniProgramToken.class).getType());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return null;
    }
}

