/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.hiylo.components.wechat.config.WechatConfig;
import org.hiylo.components.wechat.pay.WechatPayRequest;
import org.hiylo.components.wechat.pay.WechatPayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class ResponseHandle {
    @Autowired
    private WechatConfig wechatConfig;
    private WechatPayRequest wechatPayRequest;
    private Logger log = LoggerFactory.getLogger((String)this.getClass().getName());

    private ResponseHandle() {
    }

    public ResponseHandle(WechatConfig wechatConfig) {
        this.wechatPayRequest = new WechatPayRequest(wechatConfig);
    }

    @PostConstruct
    public void init() {
    }

    public String requestWithoutCert(String urlSuffix, Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        String msgUUID = reqData.get("nonce_str");
        String reqBody = WechatPayUtil.mapToXml(reqData);
        String resp = this.wechatPayRequest.requestWithoutCert(urlSuffix, msgUUID, reqBody, connectTimeoutMs, readTimeoutMs, false);
        return resp;
    }

    public String requestWithCert(String urlSuffix, Map<String, String> reqData, int connectTimeoutMs, int readTimeoutMs) {
        String msgUUID = reqData.get("nonce_str");
        String reqBody = null;
        try {
            reqBody = WechatPayUtil.mapToXml(reqData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resp = this.wechatPayRequest.requestWithCert(urlSuffix, msgUUID, reqBody, connectTimeoutMs, readTimeoutMs, false);
        return resp;
    }
}

