/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import com.github.wxpay.sdk.WXPay;
import com.github.wxpay.sdk.WXPayConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.DocumentException;
import org.hiylo.components.commons.utils.CommonUtils;
import org.hiylo.components.commons.utils.NumberUtils;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.exceptions.Constants;
import org.hiylo.components.exceptions.PaymentException;
import org.hiylo.components.wechat.config.WechatConfig;
import org.hiylo.components.wechat.pay.ResponseHandle;
import org.hiylo.components.wechat.pay.WechatNotifyVO;
import org.hiylo.components.wechat.pay.WechatPayUtil;
import org.hiylo.components.wechat.utils.Sha1Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;

public class Topay
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final String RETURN_CODE_SUCCESS = "SUCCESS";
    private static final String RETURN_CODE = "return_code";
    private final WechatConfig wechatConfig;
    private final ResponseHandle responseHandle;
    private WXPay wxPay;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public Topay(WechatConfig wechatConfig) {
        this.wechatConfig = wechatConfig;
        this.responseHandle = new ResponseHandle(wechatConfig);
        this.wxPay = new WXPay((WXPayConfig)wechatConfig);
    }

    @PostConstruct
    public void init() {
    }

    public Map getPackage(String orderItemName, String orderNo, double price, String notifyUrl, String tradeType, String ip, String openId, String attach) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, PaymentException {
        return this.getPackage(orderItemName, orderNo, price, notifyUrl, tradeType, ip, openId, attach, null);
    }

    public Map getPackage(String orderItemName, String orderNo, double price, String notifyUrl, String tradeType, String ip, String openId, String attach, String productionId) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, PaymentException {
        if (NumberUtils.greaterThanZero((double[])new double[]{price})) {
            String timestamp;
            String totalFee = String.valueOf((int)(price * 100.0));
            String mchId = this.wechatConfig.getMchID();
            String nonceStr = CommonUtils.getNonceStr();
            TreeMap<String, String> packageParams = new TreeMap<String, String>();
            packageParams.put("appid", this.wechatConfig.getAppID());
            packageParams.put("mch_id", mchId);
            packageParams.put("nonce_str", nonceStr);
            packageParams.put("attach", attach);
            packageParams.put("out_trade_no", orderNo);
            packageParams.put("spbill_create_ip", ip);
            this.log.debug(((Object)packageParams).toString());
            String prepayId = "";
            try {
                Map stringStringMap = this.wxPay.orderQuery(packageParams);
                this.log.debug("-----------------------------------------------------" + stringStringMap.toString());
                if ((!((String)stringStringMap.get(RETURN_CODE)).equals(RETURN_CODE_SUCCESS) || !Objects.nonNull(stringStringMap.get("err_code")) || !((String)stringStringMap.get("err_code")).equals("ORDERNOTEXIST")) && ((String)stringStringMap.get(RETURN_CODE)).equals(RETURN_CODE_SUCCESS) && Objects.nonNull(((String)stringStringMap.get("result_code")).equals(RETURN_CODE_SUCCESS)) && ((String)stringStringMap.get("trade_state")).equals("NOTPAY")) {
                    packageParams.remove("spbill_create_ip");
                    Map closeResult = this.wxPay.orderQuery(packageParams);
                    this.log.debug(String.valueOf(closeResult));
                }
                packageParams.put("body", orderItemName);
                packageParams.put("notify_url", notifyUrl);
                packageParams.put("openid", Optional.ofNullable(openId).orElse(""));
                packageParams.put("total_fee", totalFee);
                packageParams.put("trade_type", tradeType);
                if ("NATIVE".equals(tradeType)) {
                    packageParams.put("product_id", productionId);
                }
                this.log.debug(String.valueOf(packageParams));
                Map map = this.wxPay.unifiedOrder(packageParams);
                if ("NATIVE".equals(tradeType)) {
                    return map;
                }
                this.log.debug(String.valueOf(map));
                if (!RETURN_CODE_SUCCESS.equals(map.get(RETURN_CODE))) {
                    throw (PaymentException)PaymentException.buildException((Integer)Constants.EXCEPTION_CODE_PAYMENT_REQUEST_THIRD_PART_FAIL);
                }
                prepayId = (String)map.get("prepay_id");
                if ("".equals(prepayId)) {
                    throw (PaymentException)PaymentException.buildException((Integer)Constants.EXCEPTION_CODE_PAYMENT_REQUEST_THIRD_PART_FAIL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TreeMap<String, String> finalpackage = new TreeMap<String, String>();
            if ("APP".equals(tradeType)) {
                timestamp = Sha1Util.getTimeStamp();
                finalpackage.put("appid", this.wechatConfig.getAppID());
                finalpackage.put("partnerid", this.wechatConfig.getMchID());
                finalpackage.put("timestamp", timestamp);
                finalpackage.put("noncestr", nonceStr);
                finalpackage.put("prepayid", prepayId);
                finalpackage.put("package", "Sign=WXPay");
                String finalsign = WechatPayUtil.generateSignature(finalpackage, this.wechatConfig.getKey());
                finalpackage.put("sign", finalsign);
            } else if ("JSAPI".equals(tradeType)) {
                timestamp = Sha1Util.getTimeStamp();
                finalpackage.put("appId", this.wechatConfig.getAppID());
                finalpackage.put("timeStamp", timestamp);
                finalpackage.put("nonceStr", nonceStr);
                finalpackage.put("package", "prepay_id=" + prepayId);
                finalpackage.put("signType", "MD5");
                String finalsign = WechatPayUtil.generateSignature(finalpackage, this.wechatConfig.getKey());
                finalpackage.put("paySign", finalsign);
            }
            this.log.debug(((Object)finalpackage).toString());
            return finalpackage;
        }
        throw (PaymentException)PaymentException.buildException((Integer)Constants.EXCEPTION_CODE_PAYMENT_TOTAL_FEE_CANT_BE_ZERO);
    }

    public String refund(String transactionId, String outTradeNo, String refundTransactionId, double totalFee, double refundFee, String notifyUrl) throws PaymentException {
        String totalFeeStr = String.valueOf((int)(totalFee * 100.0));
        String refundFeeStr = String.valueOf((int)(refundFee * 100.0));
        String nonceStr = CommonUtils.getNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", this.wechatConfig.getAppID());
        packageParams.put("mch_id", this.wechatConfig.getMchID());
        packageParams.put("nonce_str", nonceStr);
        if (Objects.nonNull(transactionId)) {
            packageParams.put("transaction_id", transactionId);
        } else if (Objects.nonNull(outTradeNo)) {
            packageParams.put("out_trade_no", outTradeNo);
        } else {
            throw new PaymentException(Integer.valueOf(0x10400000), "\u5fae\u4fe1\u8ba2\u5355\u53f7\u548c\u5546\u6237\u5185\u90e8\u8ba2\u5355\u53f7\u5176\u4e2d\u4e00\u4e2a\u4e3a\u5fc5\u586b");
        }
        packageParams.put("out_refund_no", refundTransactionId);
        packageParams.put("total_fee", totalFeeStr);
        packageParams.put("refund_fee", refundFeeStr);
        packageParams.put("notify_url", notifyUrl);
        String sign = null;
        try {
            sign = WechatPayUtil.generateSignature(packageParams, this.wechatConfig.getKey());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        packageParams.put("sign", sign);
        this.log.debug(String.valueOf(packageParams));
        return this.responseHandle.requestWithCert("https://api.mch.weixin.qq.com/secapi/pay/refund", packageParams, 8000, 8000);
    }

    public WechatNotifyVO notify(HttpServletRequest request) throws IOException {
        String str;
        StringBuilder content = new StringBuilder();
        BufferedReader reader = request.getReader();
        while (Objects.nonNull(str = reader.readLine())) {
            content.append(str);
        }
        reader.close();
        return this.parseWeChatAsyncXML(content.toString());
    }

    public WechatNotifyVO notify(String weChatAsyncXML) {
        return this.parseWeChatAsyncXML(weChatAsyncXML);
    }

    private WechatNotifyVO parseWeChatAsyncXML(String content) {
        if (StringUtils.isNotEmpty((String[])new String[]{content})) {
            try {
                TreeMap asyncMap = new TreeMap((Map)CommonUtils.xml2Map((String)content, (String)"xml").get("xml"));
                if (RETURN_CODE_SUCCESS.equals(asyncMap.get(RETURN_CODE)) && RETURN_CODE_SUCCESS.equals(asyncMap.get(RETURN_CODE))) {
                    String notifySign = (String)asyncMap.get("sign");
                    asyncMap.remove("sign");
                    String notifyMySign = CommonUtils.signWithMd5(asyncMap, (String)this.wechatConfig.getKey(), (Boolean)true);
                    if (notifyMySign.equals(notifySign)) {
                        long paymentTime = new SimpleDateFormat("yyyyMMddHHmmss").parse(asyncMap.get("time_end") + "").getTime();
                        String outTradeNumber = (String)asyncMap.get("transaction_id");
                        String orderNo = (String)asyncMap.get("out_trade_no");
                        double totalFee = Double.parseDouble(asyncMap.get("total_fee").toString());
                        String attach = asyncMap.get("attach").toString();
                        return new WechatNotifyVO().setPaymentTime(paymentTime).setOutTradeNumber(outTradeNumber).setOrderNo(orderNo).setTotalFee(totalFee).setAttach(attach);
                    }
                    this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u7b7e\u540d\u5931\u8d25,\u7b7e\u540d\u53c2\u6570[" + ((Object)asyncMap).toString() + "]");
                    this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u7b7e\u540d\u5931\u8d25,\u8fd4\u56de\u7b7e\u540d[" + notifySign + "]");
                    this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u7b7e\u540d\u5931\u8d25,\u8fd4\u56de\u53c2\u6570\u52a0\u5bc6\u540e\u7b7e\u540d[" + notifyMySign + "]");
                } else {
                    this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u8fd4\u56de\u62a5\u6587:" + ((Object)asyncMap).toString());
                }
            }
            catch (ParseException | DocumentException e) {
                this.log.warn("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u5931\u8d25,\u8fd4\u56de\u62a5\u6587:", e);
                this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u5931\u8d25,\u8fd4\u56de\u62a5\u6587:" + content);
            }
            catch (SAXException e) {
                this.log.warn("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u5931\u8d25,\u8fd4\u56de\u62a5\u6587:", (Throwable)e);
                this.log.debug("\u5fae\u4fe1 <\u5f02\u6b65\u901a\u77e5> \u5931\u8d25,\u8fd4\u56de\u62a5\u6587:" + content);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String toString() {
        return "Topay{wechatConfig=" + this.wechatConfig + ", responseHandle=" + this.responseHandle + ", wxPay=" + this.wxPay + '}';
    }
}

