/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import com.github.wxpay.sdk.WXPayUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.TreeMap;
import org.hiylo.components.commons.encrypttools.Base64;
import org.hiylo.components.commons.encrypttools.Encrypt;
import org.hiylo.components.commons.utils.CommonUtils;
import org.hiylo.components.wechat.config.WechatConfig;
import org.hiylo.components.wechat.pay.ResponseHandle;
import org.hiylo.components.wechat.pay.WechatPayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class Transfers {
    private static final String NONCE_STR = "nonce_str";
    private WechatConfig wechatConfig;
    private ResponseHandle responseHandle;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    private Transfers() {
    }

    @Autowired
    public Transfers(WechatConfig wechatConfig) {
        this.wechatConfig = wechatConfig;
        this.responseHandle = new ResponseHandle(wechatConfig);
    }

    public Map<String, String> transferToBalance(String tradeNo, String openId, String realname, String amount, String description, String ip) throws Exception {
        String mchid = this.wechatConfig.getMchID();
        String nonceStr = CommonUtils.getNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("mch_appid", this.wechatConfig.getAppID());
        packageParams.put("mchid", mchid);
        packageParams.put(NONCE_STR, nonceStr);
        packageParams.put("partner_trade_no", tradeNo);
        packageParams.put("openid", openId);
        packageParams.put("check_name", "FORCE_CHECK");
        packageParams.put("re_user_name", realname);
        packageParams.put("amount", amount);
        packageParams.put("desc", description);
        packageParams.put("spbill_create_ip", ip);
        String sign = WechatPayUtil.generateSignature(packageParams, this.wechatConfig.getKey());
        packageParams.put("sign", sign);
        this.log.info("\u63d0\u73b0\u53c2\u6570 {}", packageParams);
        String s = this.responseHandle.requestWithCert("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", packageParams, 8000, 8000);
        this.log.info(s);
        return WXPayUtil.xmlToMap((String)s);
    }

    public Map<String, String> getTransferToBalanceInfo(String tradeNo, String openId, String realname, String amount, String description, String ip) throws Exception {
        String mchid = this.wechatConfig.getMchID();
        String nonceStr = CommonUtils.getNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("mch_appid", this.wechatConfig.getAppID());
        packageParams.put("mchid", mchid);
        packageParams.put(NONCE_STR, nonceStr);
        packageParams.put("partner_trade_no", tradeNo);
        packageParams.put("openid", openId);
        packageParams.put("check_name", "FORCE_CHECK");
        packageParams.put("re_user_name", realname);
        packageParams.put("amount", amount);
        packageParams.put("desc", description);
        packageParams.put("spbill_create_ip", ip);
        String sign = WechatPayUtil.generateSignature(packageParams, this.wechatConfig.getKey());
        packageParams.put("sign", sign);
        String s = this.responseHandle.requestWithCert("https://api.mch.weixin.qq.com/mmpaymkttransfers/promotion/transfers", packageParams, 8000, 8000);
        this.log.info(s);
        return WXPayUtil.xmlToMap((String)s);
    }

    public Map<String, String> transferToBankCard(String tradeNo, String realname, String amount, String description, String ip, String bankName, String bankCardNumber, String bankNote) throws Exception {
        String mchid = this.wechatConfig.getMchID();
        String nonceStr = CommonUtils.getNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("bank_code", bankName);
        packageParams.put("bank_note", bankNote);
        packageParams.put("enc_bank_no", Base64.encode((byte[])Encrypt.Rsa.encrypt((String)bankCardNumber, (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3Y+Zk2Ri0NkxAcaN93IcsWUteJM3mTpkVq/thUZhB68CC40ue3a+JqwhHy9H4TKVMsGBTbLpko4xev7s4fxCzzlRqyC1WiLEW22NY7DWZl4otPmvm005DJtfM5Agrzz/DoFxGHb4iuloYnXZ3TsEB9MfWNZY2NeI4iNlBy34KMiHBUVxehlVW5FCFamYFcClP5HqaZ4+IkhSH7+Y8CP7I2er490GboR70V3Und7PMUKHGpev/B9bRxOLNUywv0bLxEom0MCtBjUP71/8Uz3yiP06T8GAJ8rEUNLQyVSzJr8nKiOh2SUY7fPWWERalj4+u7ko8mfMIQdrGCwMNt38tQIDAQAB", (int)11, (String)"RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING")));
        packageParams.put("enc_true_name", Base64.encode((byte[])Encrypt.Rsa.encrypt((String)realname, (String)"MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3Y+Zk2Ri0NkxAcaN93IcsWUteJM3mTpkVq/thUZhB68CC40ue3a+JqwhHy9H4TKVMsGBTbLpko4xev7s4fxCzzlRqyC1WiLEW22NY7DWZl4otPmvm005DJtfM5Agrzz/DoFxGHb4iuloYnXZ3TsEB9MfWNZY2NeI4iNlBy34KMiHBUVxehlVW5FCFamYFcClP5HqaZ4+IkhSH7+Y8CP7I2er490GboR70V3Und7PMUKHGpev/B9bRxOLNUywv0bLxEom0MCtBjUP71/8Uz3yiP06T8GAJ8rEUNLQyVSzJr8nKiOh2SUY7fPWWERalj4+u7ko8mfMIQdrGCwMNt38tQIDAQAB", (int)11, (String)"RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING")));
        packageParams.put("mch_id", mchid);
        packageParams.put(NONCE_STR, nonceStr);
        packageParams.put("partner_trade_no", tradeNo);
        packageParams.put("amount", amount);
        packageParams.put("desc", description);
        packageParams.put("spbill_create_ip", ip);
        String sign = null;
        try {
            sign = WechatPayUtil.generateSignature(packageParams, this.wechatConfig.getKey());
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.log.debug("transferToBankCard", (Throwable)e);
        }
        packageParams.put("sign", sign);
        String s = this.responseHandle.requestWithCert("https://api.mch.weixin.qq.com/mmpaysptrans/pay_bank", packageParams, 8000, 8000);
        return WXPayUtil.xmlToMap((String)s);
    }

    public String getPublicKey() throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        String mchid = this.wechatConfig.getMchID();
        String nonceStr = CommonUtils.getNonceStr();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("mch_id", mchid);
        packageParams.put(NONCE_STR, nonceStr);
        String sign = WechatPayUtil.generateSignature(packageParams, this.wechatConfig.getKey());
        packageParams.put("sign", sign);
        String json = this.responseHandle.requestWithCert("https://fraud.mch.weixin.qq.com/risk/getpublickey", packageParams, 8000, 8000);
        this.log.info(json);
        return json;
    }
}

