/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import com.github.wxpay.sdk.WXPayConfig;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.conn.ConnectTimeoutException;
import org.hiylo.components.wechat.pay.IWechatPayDomain;

public class WechatPayDomainSimpleImpl
implements IWechatPayDomain {
    private final int MIN_SWITCH_PRIMARY_MSEC = 180000;
    private long switchToAlternateDomainTime = 0L;
    private Map<String, DomainStatics> domainData = new HashMap<String, DomainStatics>();

    public static IWechatPayDomain instance() {
        return WxpayDomainHolder.holder;
    }

    @Override
    public synchronized void report(String domain, long elapsedTimeMillis, Exception ex) {
        DomainStatics info = this.domainData.get(domain);
        if (info == null) {
            info = new DomainStatics(domain);
            this.domainData.put(domain, info);
        }
        if (ex == null) {
            if (info.succCount >= 2) {
                info.otherErrorCount = 0;
                info.dnsErrorCount = 0;
                info.connectTimeoutCount = 0;
            } else {
                ++info.succCount;
            }
        } else if (ex instanceof ConnectTimeoutException) {
            info.dnsErrorCount = 0;
            info.succCount = 0;
            ++info.connectTimeoutCount;
        } else if (ex instanceof UnknownHostException) {
            info.succCount = 0;
            ++info.dnsErrorCount;
        } else {
            info.succCount = 0;
            ++info.otherErrorCount;
        }
    }

    @Override
    public synchronized IWechatPayDomain.DomainInfo getDomain(WXPayConfig config) {
        DomainStatics primaryDomain = this.domainData.get("api.mch.weixin.qq.com");
        if (primaryDomain == null || primaryDomain.isGood()) {
            return new IWechatPayDomain.DomainInfo("api.mch.weixin.qq.com", true);
        }
        long now = System.currentTimeMillis();
        if (this.switchToAlternateDomainTime == 0L) {
            this.switchToAlternateDomainTime = now;
            return new IWechatPayDomain.DomainInfo("api2.mch.weixin.qq.com", false);
        }
        if (now - this.switchToAlternateDomainTime < 180000L) {
            DomainStatics alternateDomain = this.domainData.get("api2.mch.weixin.qq.com");
            if (alternateDomain == null || alternateDomain.isGood() || alternateDomain.badCount() < primaryDomain.badCount()) {
                return new IWechatPayDomain.DomainInfo("api2.mch.weixin.qq.com", false);
            }
            return new IWechatPayDomain.DomainInfo("api.mch.weixin.qq.com", true);
        }
        this.switchToAlternateDomainTime = 0L;
        primaryDomain.resetCount();
        DomainStatics alternateDomain = this.domainData.get("api2.mch.weixin.qq.com");
        if (Objects.nonNull(alternateDomain)) {
            alternateDomain.resetCount();
        }
        return new IWechatPayDomain.DomainInfo("api.mch.weixin.qq.com", true);
    }

    public String toString() {
        return "WXPayDomainSimpleImpl{MIN_SWITCH_PRIMARY_MSEC=180000, switchToAlternateDomainTime=" + this.switchToAlternateDomainTime + ", domainData=" + this.domainData + '}';
    }

    static class DomainStatics {
        final String domain;
        int succCount = 0;
        int connectTimeoutCount = 0;
        int dnsErrorCount = 0;
        int otherErrorCount = 0;

        DomainStatics(String domain) {
            this.domain = domain;
        }

        void resetCount() {
            this.otherErrorCount = 0;
            this.dnsErrorCount = 0;
            this.connectTimeoutCount = 0;
            this.succCount = 0;
        }

        boolean isGood() {
            return this.connectTimeoutCount <= 2 && this.dnsErrorCount <= 2;
        }

        int badCount() {
            return this.connectTimeoutCount + this.dnsErrorCount * 5 + this.otherErrorCount / 4;
        }
    }

    private static class WxpayDomainHolder {
        private static IWechatPayDomain holder = new WechatPayDomainSimpleImpl();

        private WxpayDomainHolder() {
        }
    }
}

