/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.hiylo.components.wechat.config.WechatConfig;
import org.hiylo.components.wechat.pay.WechatPayUtil;

public class WechatPayReport {
    private static final String REPORT_URL = "http://report.mch.weixin.qq.com/wxpay/report/default";
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 6000;
    private static final int DEFAULT_READ_TIMEOUT_MS = 8000;
    private static volatile WechatPayReport INSTANCE;
    private LinkedBlockingQueue<String> reportMsgQueue = null;
    private WechatConfig config;
    private ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("wxPayReport").build();
    private ExecutorService pool = new ThreadPoolExecutor(5, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), this.namedThreadFactory, new ThreadPoolExecutor.AbortPolicy());

    private WechatPayReport(WechatConfig config) {
        this.config = config;
        this.reportMsgQueue = new LinkedBlockingQueue(config.getReportQueueMaxSize());
        if (config.shouldAutoReport()) {
            WechatPayUtil.getLogger().info("report worker num: {}", (Object)config.getReportWorkerNum());
            for (int i = 0; i < config.getReportWorkerNum(); ++i) {
                this.pool.execute(() -> {
                    while (true) {
                        try {
                            while (true) {
                                StringBuilder sb = new StringBuilder();
                                String firstMsg = this.reportMsgQueue.take();
                                WechatPayUtil.getLogger().info("get first report msg: {}", (Object)firstMsg);
                                String msg = null;
                                sb.append(firstMsg);
                                int remainNum = config.getReportBatchSize() - 1;
                                for (int j = 0; j < remainNum; ++j) {
                                    WechatPayUtil.getLogger().info("try get remain report msg");
                                    msg = this.reportMsgQueue.take();
                                    WechatPayUtil.getLogger().info("get remain report msg: {}", (Object)msg);
                                    sb.append("\n");
                                    sb.append(msg);
                                }
                                WechatPayReport.httpRequest(sb.toString(), 6000);
                            }
                        }
                        catch (Exception ex) {
                            WechatPayUtil.getLogger().warn("report fail. reason: {}", (Object)ex.getMessage());
                            continue;
                        }
                        break;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WechatPayReport getInstance(WechatConfig config) {
        if (INSTANCE != null) return INSTANCE;
        Class<WechatPayReport> clazz = WechatPayReport.class;
        synchronized (WechatPayReport.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new WechatPayReport(config);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private static String httpRequest(String data, int connectTimeoutMs) throws IOException {
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        HttpPost httpPost = new HttpPost(REPORT_URL);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(8000).setConnectTimeout(connectTimeoutMs).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", "wxpay sdk java v1.0 ");
        httpPost.setEntity((HttpEntity)postEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
    }

    void report(String uuid, long elapsedTimeMillis, String firstDomain, boolean primaryDomain, int firstConnectTimeoutMillis, int firstReadTimeoutMillis, boolean firstHasDnsError, boolean firstHasConnectTimeout, boolean firstHasReadTimeout) {
        long currentTimestamp = WechatPayUtil.getCurrentTimestamp();
        ReportInfo reportInfo = new ReportInfo(uuid, currentTimestamp, elapsedTimeMillis, firstDomain, primaryDomain, firstConnectTimeoutMillis, firstReadTimeoutMillis, firstHasDnsError, firstHasConnectTimeout, firstHasReadTimeout);
        String data = reportInfo.toLineString(this.config.getKey());
        WechatPayUtil.getLogger().info("report {}", (Object)data);
        if (Objects.nonNull(data)) {
            this.reportMsgQueue.offer(data);
        }
    }

    @Deprecated
    private void reportSync(String data) throws Exception {
        WechatPayReport.httpRequest(data, 6000);
    }

    @Deprecated
    private void reportAsync(String data) {
        this.pool.execute(() -> {
            try {
                WechatPayReport.httpRequest(data, 6000);
            }
            catch (Exception ex) {
                WechatPayUtil.getLogger().warn("report fail. reason: {}", (Object)ex.getMessage());
            }
        });
    }

    public static class ReportInfo {
        private String version = "v0";
        private String sdk = "wxpay java sdk v1.0";
        private String uuid;
        private long timestamp;
        private long elapsedTimeMillis;
        private String firstDomain;
        private boolean primaryDomain;
        private int firstConnectTimeoutMillis;
        private int firstReadTimeoutMillis;
        private int firstHasDnsError;
        private int firstHasConnectTimeout;
        private int firstHasReadTimeout;

        ReportInfo(String uuid, long timestamp, long elapsedTimeMillis, String firstDomain, boolean primaryDomain, int firstConnectTimeoutMillis, int firstReadTimeoutMillis, boolean firstHasDnsError, boolean firstHasConnectTimeout, boolean firstHasReadTimeout) {
            this.uuid = uuid;
            this.timestamp = timestamp;
            this.elapsedTimeMillis = elapsedTimeMillis;
            this.firstDomain = firstDomain;
            this.primaryDomain = primaryDomain;
            this.firstConnectTimeoutMillis = firstConnectTimeoutMillis;
            this.firstReadTimeoutMillis = firstReadTimeoutMillis;
            this.firstHasDnsError = firstHasDnsError ? 1 : 0;
            this.firstHasConnectTimeout = firstHasConnectTimeout ? 1 : 0;
            this.firstHasReadTimeout = firstHasReadTimeout ? 1 : 0;
        }

        public String toString() {
            return "ReportInfo{version='" + this.version + '\'' + ", sdk='" + this.sdk + '\'' + ", uuid='" + this.uuid + '\'' + ", timestamp=" + this.timestamp + ", elapsedTimeMillis=" + this.elapsedTimeMillis + ", firstDomain='" + this.firstDomain + '\'' + ", primaryDomain=" + this.primaryDomain + ", firstConnectTimeoutMillis=" + this.firstConnectTimeoutMillis + ", firstReadTimeoutMillis=" + this.firstReadTimeoutMillis + ", firstHasDnsError=" + this.firstHasDnsError + ", firstHasConnectTimeout=" + this.firstHasConnectTimeout + ", firstHasReadTimeout=" + this.firstHasReadTimeout + '}';
        }

        String toLineString(String key) {
            String separator = ",";
            Object[] objects = new Object[]{this.version, this.sdk, this.uuid, this.timestamp, this.elapsedTimeMillis, this.firstDomain, this.primaryDomain, this.firstConnectTimeoutMillis, this.firstReadTimeoutMillis, this.firstHasDnsError, this.firstHasConnectTimeout, this.firstHasReadTimeout};
            StringBuilder sb = new StringBuilder();
            for (Object obj : objects) {
                sb.append(obj).append(separator);
            }
            try {
                String sign = WechatPayUtil.HMACSHA256(sb.toString(), key);
                sb.append(sign);
                return sb.toString();
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

