/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.hiylo.components.wechat.config.WechatConfig;
import org.hiylo.components.wechat.pay.IWechatPayDomain;
import org.hiylo.components.wechat.pay.WechatPayReport;
import org.hiylo.components.wechat.pay.WechatPayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatPayRequest {
    private static final Logger log = LoggerFactory.getLogger(WechatPayRequest.class);
    private WechatConfig config;

    public WechatPayRequest(WechatConfig config) {
        this.config = config;
    }

    private String requestOnce(String domain, String urlSuffix, String uuid, String data, int connectTimeoutMs, int readTimeoutMs, boolean useCert) throws Exception {
        BasicHttpClientConnectionManager connManager;
        if (useCert) {
            char[] password = this.config.getMchID().toCharArray();
            InputStream certStream = this.config.getCertStream();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(certStream, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), null, new SecureRandom());
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1"}, null, (HostnameVerifier)new DefaultHostnameVerifier());
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build(), null, null, null);
        } else {
            connManager = new BasicHttpClientConnectionManager((Lookup)RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build(), null, null, null);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).build();
        String url = urlSuffix;
        HttpPost httpPost = new HttpPost(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(readTimeoutMs).setConnectTimeout(connectTimeoutMs).build();
        httpPost.setConfig(requestConfig);
        StringEntity postEntity = new StringEntity(data, "UTF-8");
        httpPost.addHeader("Content-Type", "text/xml");
        httpPost.addHeader("User-Agent", "wxpay sdk java v1.0 " + this.config.getMchID());
        httpPost.setEntity((HttpEntity)postEntity);
        HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        HttpEntity httpEntity = httpResponse.getEntity();
        return EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
    }

    private String request(String urlSuffix, String uuid, String data, int connectTimeoutMs, int readTimeoutMs, boolean useCert, boolean autoReport) throws Exception {
        long elapsedTimeMillis;
        Throwable exception;
        long startTimestampMs = WechatPayUtil.getCurrentTimestampMs();
        boolean firstHasDnsErr = false;
        boolean firstHasConnectTimeout = false;
        boolean firstHasReadTimeout = false;
        IWechatPayDomain.DomainInfo domainInfo = this.config.getWechatPayDomain().getDomain(this.config);
        if (domainInfo == null) {
            throw new Exception("AbstractWXPayConfig.getWXPayDomain().getDomain() is empty or null");
        }
        try {
            String result = this.requestOnce(domainInfo.domain, urlSuffix, uuid, data, connectTimeoutMs, readTimeoutMs, useCert);
            long elapsedTimeMillis2 = WechatPayUtil.getCurrentTimestampMs() - startTimestampMs;
            this.config.getWechatPayDomain().report(domainInfo.domain, elapsedTimeMillis2, null);
            WechatPayReport.getInstance(this.config).report(uuid, elapsedTimeMillis2, domainInfo.domain, domainInfo.primaryDomain, connectTimeoutMs, readTimeoutMs, firstHasDnsErr, firstHasConnectTimeout, firstHasReadTimeout);
            return result;
        }
        catch (UnknownHostException ex) {
            exception = ex;
            firstHasDnsErr = true;
            elapsedTimeMillis = WechatPayUtil.getCurrentTimestampMs() - startTimestampMs;
            WechatPayUtil.getLogger().warn("UnknownHostException for domainInfo {}", (Object)domainInfo);
            WechatPayReport.getInstance(this.config).report(uuid, elapsedTimeMillis, domainInfo.domain, domainInfo.primaryDomain, connectTimeoutMs, readTimeoutMs, firstHasDnsErr, firstHasConnectTimeout, firstHasReadTimeout);
        }
        catch (ConnectTimeoutException ex) {
            exception = ex;
            firstHasConnectTimeout = true;
            elapsedTimeMillis = WechatPayUtil.getCurrentTimestampMs() - startTimestampMs;
            WechatPayUtil.getLogger().warn("connect timeout happened for domainInfo {}", (Object)domainInfo);
            WechatPayReport.getInstance(this.config).report(uuid, elapsedTimeMillis, domainInfo.domain, domainInfo.primaryDomain, connectTimeoutMs, readTimeoutMs, firstHasDnsErr, firstHasConnectTimeout, firstHasReadTimeout);
        }
        catch (SocketTimeoutException ex) {
            exception = ex;
            firstHasReadTimeout = true;
            elapsedTimeMillis = WechatPayUtil.getCurrentTimestampMs() - startTimestampMs;
            WechatPayUtil.getLogger().warn("timeout happened for domainInfo {}", (Object)domainInfo);
            WechatPayReport.getInstance(this.config).report(uuid, elapsedTimeMillis, domainInfo.domain, domainInfo.primaryDomain, connectTimeoutMs, readTimeoutMs, firstHasDnsErr, firstHasConnectTimeout, firstHasReadTimeout);
        }
        catch (Exception ex) {
            exception = ex;
            elapsedTimeMillis = WechatPayUtil.getCurrentTimestampMs() - startTimestampMs;
            WechatPayReport.getInstance(this.config).report(uuid, elapsedTimeMillis, domainInfo.domain, domainInfo.primaryDomain, connectTimeoutMs, readTimeoutMs, firstHasDnsErr, firstHasConnectTimeout, firstHasReadTimeout);
        }
        this.config.getWechatPayDomain().report(domainInfo.domain, elapsedTimeMillis, (Exception)exception);
        throw exception;
    }

    public String requestWithoutCert(String urlSuffix, String uuid, String data, boolean autoReport) throws Exception {
        return this.request(urlSuffix, uuid, data, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs(), false, autoReport);
    }

    public String requestWithoutCert(String urlSuffix, String uuid, String data, int connectTimeoutMs, int readTimeoutMs, boolean autoReport) throws Exception {
        return this.request(urlSuffix, uuid, data, connectTimeoutMs, readTimeoutMs, false, autoReport);
    }

    public String requestWithCert(String urlSuffix, String uuid, String data, boolean autoReport) throws Exception {
        return this.request(urlSuffix, uuid, data, this.config.getHttpConnectTimeoutMs(), this.config.getHttpReadTimeoutMs(), true, autoReport);
    }

    public String requestWithCert(String urlSuffix, String uuid, String data, int connectTimeoutMs, int readTimeoutMs, boolean autoReport) {
        try {
            return this.request(urlSuffix, uuid, data, connectTimeoutMs, readTimeoutMs, true, autoReport);
        }
        catch (Exception e) {
            log.error("wechat request", (Throwable)e);
            return null;
        }
    }
}

