/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.pay;

import com.github.wxpay.sdk.WXPayConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WechatPayUtil {
    private static final Logger log = LoggerFactory.getLogger(WechatPayUtil.class);

    public static Map<String, String> xmlToMap(String strXML) throws IOException, SAXException, ParserConfigurationException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(strXML.getBytes(StandardCharsets.UTF_8));
            Document doc = documentBuilder.parse(stream);
            doc.getDocumentElement().normalize();
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            HashMap<String, String> data = new HashMap<String, String>(nodeList.getLength());
            for (int idx = 0; idx < nodeList.getLength(); ++idx) {
                Node node = nodeList.item(idx);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                data.put(element.getNodeName(), element.getTextContent());
            }
            try {
                ((InputStream)stream).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return data;
        }
        catch (SAXException e) {
            WechatPayUtil.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)e.getMessage(), (Object)strXML);
            throw e;
        }
        catch (UnsupportedEncodingException e) {
            WechatPayUtil.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)e.getMessage(), (Object)strXML);
            throw e;
        }
        catch (IOException e) {
            WechatPayUtil.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)e.getMessage(), (Object)strXML);
            throw e;
        }
        catch (ParserConfigurationException e) {
            WechatPayUtil.getLogger().warn("Invalid XML, can not convert to map. Error message: {}. XML content: {}", (Object)e.getMessage(), (Object)strXML);
            throw e;
        }
    }

    public static String mapToXml(Map<String, String> data) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element root = document.createElement("xml");
        document.appendChild(root);
        for (String key : data.keySet()) {
            String value = data.get(key);
            if (value == null) {
                value = "";
            }
            value = value.trim();
            Element filed = document.createElement(key);
            filed.appendChild(document.createTextNode(value));
            root.appendChild(filed);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(source, result);
        String output = writer.getBuffer().toString();
        try {
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return output;
    }

    public static String generateSignedXml(Map<String, String> data, String key) throws ParserConfigurationException, TransformerException, NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        return WechatPayUtil.generateSignedXml(data, key, WXPayConstants.SignType.MD5);
    }

    public static String generateSignedXml(Map<String, String> data, String key, WXPayConstants.SignType signType) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, TransformerException, ParserConfigurationException {
        String sign = WechatPayUtil.generateSignature(data, key, signType);
        data.put("sign", sign);
        return WechatPayUtil.mapToXml(data);
    }

    public static boolean isSignatureValid(String xmlStr, String key) throws ParserConfigurationException, SAXException, IOException, InvalidKeyException, NoSuchAlgorithmException {
        Map<String, String> data = WechatPayUtil.xmlToMap(xmlStr);
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WechatPayUtil.generateSignature(data, key).equals(sign);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        return WechatPayUtil.isSignatureValid(data, key, WXPayConstants.SignType.MD5);
    }

    public static boolean isSignatureValid(Map<String, String> data, String key, WXPayConstants.SignType signType) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        if (!data.containsKey("sign")) {
            return false;
        }
        String sign = data.get("sign");
        return WechatPayUtil.generateSignature(data, key, signType).equals(sign);
    }

    public static String generateSignature(Map<String, String> data, String key) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        return WechatPayUtil.generateSignature(data, key, WXPayConstants.SignType.MD5);
    }

    public static String generateSignature(Map<String, String> data, String key, WXPayConstants.SignType signType) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        Set<String> keySet = data.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign")) continue;
            log.debug((String)k + "     " + data.get(k));
            if (!Objects.nonNull(data.get(k)) || data.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(data.get(k).trim()).append("&");
        }
        sb.append("key=").append(key);
        if (WXPayConstants.SignType.MD5.equals((Object)signType)) {
            return WechatPayUtil.MD5(sb.toString()).toUpperCase();
        }
        if (WXPayConstants.SignType.HMACSHA256.equals((Object)signType)) {
            return WechatPayUtil.HMACSHA256(sb.toString(), key);
        }
        throw new RuntimeException(String.format("Invalid sign_type: %s", signType));
    }

    public static String generateNonceStr() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }

    public static String MD5(String data) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] array = md.digest(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100), 1, 3);
        }
        return sb.toString().toUpperCase();
    }

    public static String HMACSHA256(String data, String key) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100), 1, 3);
        }
        return sb.toString().toUpperCase();
    }

    public static Logger getLogger() {
        Logger log = LoggerFactory.getLogger((String)"wxpay java sdk");
        return log;
    }

    public static long getCurrentTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long getCurrentTimestampMs() {
        return System.currentTimeMillis();
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }
}

