/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.user;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.Objects;
import org.hiylo.components.commons.utils.HttpClient;
import org.hiylo.components.fentity.vo.WechatServiceToken;
import org.hiylo.components.fentity.vo.WechatUserInfo;
import org.hiylo.components.fentity.vo.WechatUserOpenIdInfo;
import org.hiylo.components.fentity.vo.WechatUserToken;
import org.hiylo.components.wechat.WechatPublicAccountConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class WechatUtils {
    private static final Logger log = LoggerFactory.getLogger(WechatUtils.class);
    private HttpClient httpClient = new HttpClient();
    private Gson gson = new Gson();
    private WechatPublicAccountConstants wechatPublicAccountConstants;

    @Autowired
    public WechatUtils(WechatPublicAccountConstants wechatPublicAccountConstants) {
        this.wechatPublicAccountConstants = wechatPublicAccountConstants;
    }

    public WechatUserToken getUserToken(String code) {
        try {
            String result = this.httpClient.get(this.wechatPublicAccountConstants.getUserAuthorizationTokenUrl(code));
            log.info(result);
            return (WechatUserToken)this.gson.fromJson(result, TypeToken.get(WechatUserToken.class).getType());
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("getUserToken", e);
            return null;
        }
    }

    public WechatServiceToken getServiceToken() {
        try {
            log.info("getServiceToken {}", (Object)this.wechatPublicAccountConstants.getGrantClientCredentialTokenUrl());
            String result = this.httpClient.get(this.wechatPublicAccountConstants.getGrantClientCredentialTokenUrl());
            log.info("getServiceToken {}", (Object)result);
            return (WechatServiceToken)this.gson.fromJson(result, TypeToken.get(WechatServiceToken.class).getType());
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("getServiceToken", e);
            return null;
        }
    }

    public WechatServiceToken getJsTicket(String accessToken) {
        try {
            String result = this.httpClient.get(this.wechatPublicAccountConstants.getJsTicketUrl(accessToken));
            return (WechatServiceToken)this.gson.fromJson(result, TypeToken.get(WechatServiceToken.class).getType());
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("getJsTicket", e);
            return null;
        }
    }

    public WechatUserOpenIdInfo getOpenId(String code) {
        String result = this.httpClient.httpsRequest(this.wechatPublicAccountConstants.getUserAuthorizationTokenUrl(code), "GET", null);
        log.info(result);
        if (Objects.nonNull(result)) {
            return (WechatUserOpenIdInfo)this.gson.fromJson(result, WechatUserOpenIdInfo.class);
        }
        return null;
    }

    public WechatUserInfo getUserInfo(String accessToken, String openId) {
        String result = this.httpClient.httpsRequest(this.wechatPublicAccountConstants.getUserInfoUrl(accessToken, openId), "GET", null);
        if (Objects.nonNull(result)) {
            return (WechatUserInfo)this.gson.fromJson(result, TypeToken.get(WechatUserInfo.class).getType());
        }
        return null;
    }
}

