/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.wechat.utils;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.sf.json.JSONObject;
import org.hiylo.components.commons.utils.StringUtils;
import org.hiylo.components.wechat.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PushMessage
extends StringUtils {
    private static final Logger log = LoggerFactory.getLogger(PushMessage.class);
    private Gson gson = new Gson();

    public void pushMessage(String openId, String templateId, Map<String, String> map, String accessToken, String url) {
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=ACCESS_TOKEN";
        requestUrl = requestUrl.replace("ACCESS_TOKEN", accessToken);
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("template_id", templateId);
        Optional.ofNullable(url).ifPresent(s -> json.put("url", s));
        HashMap values = new HashMap();
        for (String key : map.keySet()) {
            String value = map.get(key);
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("color", "#173177");
            temp.put("value", value);
            values.put(key, temp);
        }
        json.put("data", values);
        JSONObject jsonObject = CommonUtils.httpsRequest(requestUrl, "POST", this.gson.toJson(json));
        log.debug("\u5fae\u4fe1\u63a8\u9001\u6d88\u606f {}", (Object)jsonObject);
    }

    public void sendSubscribeMessage(String openId, String templateId, Map<String, String> map, String accessToken) {
        this.sendSubscribeMessage(openId, templateId, map, accessToken, null, null);
    }

    public void sendSubscribeMessage(String openId, String templateId, Map<String, String> map, String accessToken, String url) {
        this.sendSubscribeMessage(openId, templateId, map, accessToken, url, null);
    }

    public void sendSubscribeMessage(String openId, String templateId, Map<String, String> map, String accessToken, String url, String state) {
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/subscribe/send?access_token=ACCESS_TOKEN";
        requestUrl = requestUrl.replace("ACCESS_TOKEN", accessToken);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("touser", openId);
        json.put("template_id", templateId);
        Optional.ofNullable(url).ifPresent(s -> json.put("page", (String)s));
        Optional.ofNullable(state).ifPresent(s -> json.put("miniprogram_state", (String)s));
        json.put("lang", "zh_CN");
        JSONObject jsonObject = new JSONObject();
        for (String key : map.keySet()) {
            JSONObject tempJsonObject = new JSONObject();
            tempJsonObject.put((Object)"value", (Object)map.get(key));
            jsonObject.put((Object)key, (Object)tempJsonObject);
        }
        json.put("data", (String)jsonObject);
        jsonObject = CommonUtils.httpsRequest(requestUrl, "POST", this.gson.toJson(json));
        log.debug("\u5fae\u4fe1\u63a8\u9001\u6d88\u606f {}", (Object)jsonObject);
    }

    public void sendUniformMessage(String wechatAppId, String miniProgramAppId, String openId, String miniProgramTemplateId, String miniProgramFormId, String wechatTemplateId, Map<String, String> map, String accessToken, String url, String emphasisKeyword) {
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/message/wxopen/template/uniform_send?access_token=ACCESS_TOKEN";
        requestUrl = requestUrl.replace("ACCESS_TOKEN", accessToken);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("touser", openId);
        Optional.ofNullable(miniProgramTemplateId).ifPresent(s -> json.put("weapp_template_msg", (String)this.buildWeappMessage((String)s, miniProgramFormId, url, map, emphasisKeyword)));
        json.put("mp_template_msg", (String)this.buildWechatMessage(wechatAppId, wechatTemplateId, url, map, miniProgramAppId));
    }

    private JSONObject buildWechatMessage(String wechatAppId, String wechatTemplateId, String url, Map<String, String> map, String miniProgramAppId) {
        JSONObject json = new JSONObject();
        json.put((Object)"appid", (Object)wechatAppId);
        json.put((Object)"template_id", (Object)wechatTemplateId);
        json.put((Object)"page", (Object)url);
        JSONObject jsonObject = new JSONObject();
        for (String key : map.keySet()) {
            JSONObject tempJsonObject = new JSONObject();
            tempJsonObject.put((Object)"value", (Object)map.get(key));
            jsonObject.put((Object)key, (Object)tempJsonObject);
        }
        json.put((Object)"data", (Object)jsonObject);
        return json;
    }

    private JSONObject buildWeappMessage(String templateId, String formId, String url, Map<String, String> map, String emphasisKeyword) {
        JSONObject json = new JSONObject();
        json.put((Object)"template_id", (Object)templateId);
        json.put((Object)"page", (Object)url);
        json.put((Object)"form_id", (Object)formId);
        json.put((Object)"emphasis_keyword", (Object)emphasisKeyword);
        JSONObject jsonObject = new JSONObject();
        for (String key : map.keySet()) {
            JSONObject tempJsonObject = new JSONObject();
            tempJsonObject.put((Object)"value", (Object)map.get(key));
            jsonObject.put((Object)key, (Object)tempJsonObject);
        }
        json.put((Object)"data", (Object)jsonObject);
        return json;
    }

    public static enum MiniProgramState {
        DEVELOPER("developer"),
        TRIAL("trial"),
        FORMAL("formal");

        private String state;

        private MiniProgramState(String state) {
            this.state = state;
        }

        public String getState() {
            return this.state;
        }
    }
}

