/*
 * Decompiled with CFR 0.152.
 */
package org.hiylo.components.zookeeper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.hiylo.components.zookeeper.I0ItecZooKeeperServiceProviderSubscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class I0ItecZooKeeperServiceProvider {
    private static ZkClient zkClient;
    private static Logger log;
    @Value(value="${zookeeper.locations}")
    public String zookeeperServerLocation;

    private I0ItecZooKeeperServiceProvider() {
    }

    public I0ItecZooKeeperServiceProvider(String zookeeperServerLocation) {
        this.zookeeperServerLocation = zookeeperServerLocation;
        zkClient = new ZkClient(zookeeperServerLocation);
    }

    @PostConstruct
    private void init() {
        zkClient = new ZkClient(this.zookeeperServerLocation);
    }

    public void put(String path, String value) {
        boolean serviceExists = zkClient.exists(path);
        if (!serviceExists) {
            this.createPath(path);
        }
        if (!zkClient.exists(path + "/" + value)) {
            zkClient.createEphemeral(path + "/" + value);
        } else {
            zkClient.delete(path + "/" + value);
            this.put(path, value);
        }
    }

    public List<String> get(String path) {
        boolean serviceExists = zkClient.exists(path);
        if (serviceExists) {
            return zkClient.getChildren(path);
        }
        this.createPath(path);
        return Collections.emptyList();
    }

    public void resetZookeeper(String path) {
        log.debug(path);
        try {
            ZooKeeper zookeeper = new ZooKeeper(this.zookeeperServerLocation, 300000, null);
            List names = zookeeper.getChildren(path, null);
            for (String name : names) {
                String tempPath = "";
                tempPath = "/".equals(path) ? path + name : path + "/" + name;
                this.resetZookeeper(tempPath);
                zookeeper.delete(tempPath, -1);
            }
        }
        catch (IOException | KeeperException e) {
            log.debug("resetZookeeper", e);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void subscribeChildChanges(String path, Object obj) {
        boolean serviceExists;
        if (!(obj instanceof I0ItecZooKeeperServiceProviderSubscribe)) {
            throw new RuntimeException("Not a subscribe");
        }
        if (zkClient == null) {
            zkClient = new ZkClient(this.zookeeperServerLocation);
        }
        if (!(serviceExists = zkClient.exists(path))) {
            this.createPath(path);
        }
        zkClient.subscribeChildChanges(path, (parentPath, currentChilds) -> obj.getClass().getMethod("callback", List.class).invoke(obj, currentChilds));
    }

    private void createPath(String path) {
        String[] paths = path.split("/");
        String ps = "";
        for (String p : paths) {
            boolean exists;
            if (!StringUtils.hasText((String)p) || (exists = zkClient.exists(ps = ps + "/" + p))) continue;
            zkClient.createPersistent(ps);
        }
    }

    static {
        log = LoggerFactory.getLogger(I0ItecZooKeeperServiceProvider.class);
    }
}

