/*
 * Decompiled with CFR 0.152.
 */
package org.hjug.dtangler.ui.dsm.impl;

import org.hjug.dtangler.core.dsm.DsmRow;
import org.hjug.dtangler.ui.dsm.DependableInfo;
import org.hjug.dtangler.ui.dsm.impl.Formatter;

public class DependableInfoImpl
implements DependableInfo {
    private final DsmRow dsmRow;
    private final int index;
    private final boolean isSelected;
    private final boolean isInCrossHair;
    private final boolean containsErrors;
    private final boolean containsWarnings;
    private final Formatter displayNameFormatter;

    public DependableInfoImpl(DsmRow dsmRow, int index, boolean isInCrossHair, boolean isSelected, boolean containsErrors, boolean containsWarnings, Formatter displayNameFormatter) {
        this.dsmRow = dsmRow;
        this.index = index;
        this.isInCrossHair = isInCrossHair;
        this.isSelected = isSelected;
        this.containsErrors = containsErrors;
        this.containsWarnings = containsWarnings;
        this.displayNameFormatter = displayNameFormatter;
    }

    @Override
    public int getContentCount() {
        return this.dsmRow.getDependee().getContentCount();
    }

    @Override
    public String getDisplayName() {
        return this.displayNameFormatter.format(this.dsmRow.getDependee().getDisplayName());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isInCrosshair() {
        return this.isInCrossHair;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public boolean containsErrors() {
        return this.containsErrors;
    }

    @Override
    public boolean containsWarnings() {
        return this.containsWarnings;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.dsmRow.getDependee().getFullyQualifiedName();
    }
}

