/*
 * Decompiled with CFR 0.152.
 */
package org.hjug.dtangler.ui.dsm.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hjug.dtangler.core.analysisresult.AnalysisResult;
import org.hjug.dtangler.core.analysisresult.Violation;
import org.hjug.dtangler.core.dependencies.Dependable;
import org.hjug.dtangler.core.dependencies.Dependency;
import org.hjug.dtangler.core.dsm.Dsm;
import org.hjug.dtangler.core.dsm.DsmCell;
import org.hjug.dtangler.core.dsm.DsmRow;
import org.hjug.dtangler.ui.dsm.CellInfo;
import org.hjug.dtangler.ui.dsm.DependableInfo;
import org.hjug.dtangler.ui.dsm.DsmGuiModel;
import org.hjug.dtangler.ui.dsm.DsmGuiModelChangeListener;
import org.hjug.dtangler.ui.dsm.NullCellInfo;
import org.hjug.dtangler.ui.dsm.impl.AnalysisResultInfoImpl;
import org.hjug.dtangler.ui.dsm.impl.CellInfoImpl;
import org.hjug.dtangler.ui.dsm.impl.ColumnAndRowSelectionModel;
import org.hjug.dtangler.ui.dsm.impl.DependableInfoImpl;
import org.hjug.dtangler.ui.dsm.impl.Formatter;
import org.hjug.dtangler.ui.dsm.impl.PassThroughFormatter;
import org.hjug.dtangler.ui.dsm.impl.ShortenedNameFormatter;

public class DsmGuiModelImpl
implements DsmGuiModel,
ColumnAndRowSelectionModel {
    private final List<DsmGuiModelChangeListener> listeners = new ArrayList<DsmGuiModelChangeListener>();
    private Formatter displayNameFormatter;
    private DsmGuiModel.DisplayNameFormat displayNameFormat = DsmGuiModel.DisplayNameFormat.full;
    private Dsm dsm;
    private AnalysisResult analysisResult;
    private List<Integer> selectedRows = Collections.EMPTY_LIST;
    private List<Integer> selectedCols = Collections.EMPTY_LIST;
    private int crossHairRow = -1;
    private int crossHairCol = -1;
    private final Map<Integer, Map<Integer, CellInfo>> cellInfoCache = new HashMap<Integer, Map<Integer, CellInfo>>();

    @Override
    public CellInfo getCellInfo(int row, int col) {
        CellInfo cellInfo;
        Map<Integer, CellInfo> rowCache = this.cellInfoCache.get(row);
        if (rowCache == null) {
            rowCache = new HashMap<Integer, CellInfo>();
            this.cellInfoCache.put(row, rowCache);
        }
        if ((cellInfo = rowCache.get(col)) == null) {
            cellInfo = this.createCellInfo(row, col);
            rowCache.put(col, cellInfo);
        }
        return cellInfo;
    }

    private CellInfo createCellInfo(int row, int col) {
        DsmCell dsmCell = this.getDsmCell(row, col);
        if (!dsmCell.isValid()) {
            return NullCellInfo.instance;
        }
        Dependency dependency = ((DsmCell)((DsmRow)this.dsm.getRows().get(row)).getCells().get(col)).getDependency();
        return new CellInfoImpl(dsmCell, new AnalysisResultInfoImpl(this.hasViolations(dependency, Violation.Severity.error), this.hasViolations(dependency, Violation.Severity.warning)), row, col, this);
    }

    private boolean hasViolations(Dependency dependency, Violation.Severity severity) {
        return !this.analysisResult.getViolations(dependency, severity).isEmpty();
    }

    private boolean containsViolations(Dependable dependable, Violation.Severity severity) {
        return !this.analysisResult.getChildViolations(dependable, severity).isEmpty();
    }

    @Override
    public boolean isRowOrColumnInCrossHair(int row, int col) {
        if (this.multiCellSelectionExists()) {
            return false;
        }
        return this.crossHairRow == row || this.crossHairCol == col;
    }

    @Override
    public int getColumnCount() {
        return this.getRowCount();
    }

    @Override
    public DependableInfo getColumnInfo(int index) {
        return this.createDependableInfo(index, false);
    }

    @Override
    public DependableInfo getRowInfo(int index) {
        boolean isSelected = this.selectedRows.contains(index) && this.selectedCols.isEmpty();
        return this.createDependableInfo(index, isSelected);
    }

    private DependableInfo createDependableInfo(int index, boolean isSelected) {
        boolean isInCrossHair = this.isInCrosshair(index);
        DsmRow dsmRow = (DsmRow)this.dsm.getRows().get(index);
        return new DependableInfoImpl(dsmRow, index + 1, isInCrossHair, isSelected, this.containsViolations(dsmRow.getDependee(), Violation.Severity.error), this.containsViolations(dsmRow.getDependee(), Violation.Severity.warning), this.getDisplayNameFormatter());
    }

    private boolean isInCrosshair(int index) {
        if (this.multiCellSelectionExists()) {
            return false;
        }
        return this.crossHairCol == index || this.crossHairRow == index;
    }

    private boolean multiCellSelectionExists() {
        return this.selectedCols.size() != 1 || this.selectedRows.size() != 1;
    }

    private DsmCell getDsmCell(int row, int col) {
        return (DsmCell)((DsmRow)this.dsm.getRows().get(row)).getCells().get(col);
    }

    @Override
    public int getRowCount() {
        if (this.dsm == null) {
            return 0;
        }
        return this.dsm.getRows().size();
    }

    @Override
    public void selectCells(List<Integer> rows, List<Integer> cols) {
        this.selectedRows = rows;
        this.selectedCols = cols;
        this.crossHairRow = !rows.isEmpty() ? rows.get(0) : -1;
        this.crossHairCol = !cols.isEmpty() ? cols.get(0) : -1;
        this.fireDsmGuiModelChanged();
    }

    @Override
    public List<Integer> getSelectedRows() {
        return this.selectedRows;
    }

    @Override
    public List<Integer> getSelectedCols() {
        return this.selectedCols;
    }

    private void fireDsmGuiModelChanged() {
        for (DsmGuiModelChangeListener listener : this.listeners) {
            listener.dsmGuiModelChanged();
        }
    }

    private void fireDsmDataChanged() {
        for (DsmGuiModelChangeListener listener : this.listeners) {
            listener.dsmDataChanged();
        }
    }

    @Override
    public void addChangeListener(DsmGuiModelChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void clearSelection() {
        this.selectCells(Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    @Override
    public void setDsm(Dsm dsm, AnalysisResult analysisResult) {
        this.analysisResult = analysisResult;
        this.clearSelection();
        this.cellInfoCache.clear();
        this.dsm = dsm;
        this.displayNameFormatter = null;
        this.fireDsmDataChanged();
    }

    @Override
    public Set<Dependency> getSelectionDependencies() {
        HashSet<Dependency> result = new HashSet<Dependency>();
        for (Integer col : this.selectedCols) {
            for (Integer row : this.selectedRows) {
                result.add(this.getDsmCell(row, col).getDependency());
            }
        }
        return result;
    }

    @Override
    public Set<Dependable> getSelectionDependables() {
        if (this.selectedRows.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Set<Dependency> selectionDependencies = this.getSelectionDependencies();
        HashSet<Dependable> result = new HashSet<Dependable>();
        if (selectionDependencies.isEmpty()) {
            for (int row : this.selectedRows) {
                result.add(((DsmRow)this.dsm.getRows().get(row)).getDependee());
            }
        } else {
            for (Dependency dependency : selectionDependencies) {
                result.add(dependency.getDependant());
                result.add(dependency.getDependee());
            }
        }
        return result;
    }

    @Override
    public boolean isSelected(int row, int col) {
        return this.selectedRows.contains(row) && this.selectedCols.contains(col);
    }

    @Override
    public void setDisplayNameFormat(DsmGuiModel.DisplayNameFormat nameFormat) {
        if (nameFormat.equals((Object)this.displayNameFormat)) {
            return;
        }
        this.displayNameFormat = nameFormat;
        this.displayNameFormatter = null;
        this.fireDsmGuiModelChanged();
    }

    private Formatter getDisplayNameFormatter() {
        if (this.displayNameFormatter == null) {
            this.displayNameFormatter = this.displayNameFormat.equals((Object)DsmGuiModel.DisplayNameFormat.shortened) ? new ShortenedNameFormatter(this.getRowNames()) : new PassThroughFormatter();
        }
        return this.displayNameFormatter;
    }

    private List<String> getRowNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DsmRow row : this.dsm.getRows()) {
            names.add(row.getDependee().getDisplayName());
        }
        return names;
    }

    @Override
    public DsmGuiModel.DisplayNameFormat getDisplayNameFormat() {
        return this.displayNameFormat;
    }
}

