/*
 * Decompiled with CFR 0.152.
 */
package org.hjug.dtangler.ui.dsm.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.hjug.dtangler.ui.dsm.impl.Formatter;

public class ShortenedNameFormatter
implements Formatter {
    private int commonPrefixLength;
    private int commonPostfixLength;

    public ShortenedNameFormatter(Collection<String> allItems) {
        this.commonPrefixLength = this.getCommonPrefixLength(allItems);
        this.commonPostfixLength = this.getCommonPostfixLength(allItems);
    }

    private int getCommonPrefixLength(Collection<String> allItems) {
        if (allItems.size() < 2) {
            return 0;
        }
        int index = 0;
        int lastCommonSeperationPoint = 0;
        while (true) {
            Character nextChar = null;
            for (String item : allItems) {
                if (item.length() < index + 1) {
                    return lastCommonSeperationPoint;
                }
                char c = item.charAt(index);
                if (nextChar == null) {
                    nextChar = Character.valueOf(c);
                }
                if (nextChar.charValue() == c) continue;
                return lastCommonSeperationPoint;
            }
            if (!Character.isLetterOrDigit(nextChar.charValue())) {
                lastCommonSeperationPoint = index + 1;
            }
            ++index;
        }
    }

    private int getCommonPostfixLength(Collection<String> allItems) {
        ArrayList<String> inversions = new ArrayList<String>();
        for (String item : allItems) {
            inversions.add(this.inverse(item));
        }
        return this.getCommonPrefixLength(inversions);
    }

    private String inverse(String item) {
        StringBuilder sb = new StringBuilder();
        for (int i = item.length() - 1; i >= 0; --i) {
            sb.append(item.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public String format(Object item) {
        if (item.equals("")) {
            return "";
        }
        String leftTrimmed = item.toString().substring(this.commonPrefixLength);
        String result = leftTrimmed.substring(0, leftTrimmed.length() - this.commonPostfixLength);
        return result;
    }
}

