/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.bookscan;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.hogel.bookscan.Connector;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class BasicConnector
implements Connector {
    private final Map<String, String> cookies = new TreeMap<String, String>();

    @Override
    public Connection connect(String url) {
        return Jsoup.connect((String)url).cookies(this.cookies);
    }

    @Override
    public Document execute(Connection connection) throws IOException {
        Connection.Response response = connection.execute();
        this.cookies.putAll(response.cookies());
        return response.parse();
    }

    @Override
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public void putCookies(Map<String, String> cookies) {
        this.cookies.putAll(cookies);
    }

    @Override
    public void clearCookies() {
        this.cookies.clear();
    }
}

