/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.bookscan;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.hogel.bookscan.BasicConnector;
import org.hogel.bookscan.Connector;
import org.hogel.bookscan.OptimizeOption;
import org.hogel.bookscan.exception.BookscanException;
import org.hogel.bookscan.exception.BookscanNetworkException;
import org.hogel.bookscan.exception.BookscanResponseException;
import org.hogel.bookscan.model.Book;
import org.hogel.bookscan.model.OptimizedBook;
import org.hogel.bookscan.model.OptimizingBook;
import org.hogel.bookscan.reqeust.Request;
import org.jsoup.Connection;
import org.jsoup.helper.HttpConnection;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookscanClient {
    private static final Logger LOG = LoggerFactory.getLogger(BookscanClient.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final Connector connector;
    private final ExecutorService executorService;
    private static final Pattern OPTIMIZING_BOOK_PATTERN = Pattern.compile("(.+\\.pdf)\\s*\u30c1\u30e5\u30fc\u30cb\u30f3\u30b0\u30bf\u30a4\u30d7:(.+)\\s*\u30c1\u30e5\u30fc\u30cb\u30f3\u30b0\u4f9d\u983c\u65e5\u6642:(\\d+\u5e74\\d+\u6708\\d+\u65e5 \\d+:\\d+)\\s*(.+)\\s+\u512a\u5148\u5ea6:");

    public BookscanClient() {
        this(new BasicConnector());
    }

    public BookscanClient(Connector connector) {
        this(Executors.newSingleThreadExecutor(), connector);
    }

    public BookscanClient(ExecutorService executorService, Connector connector) {
        this.connector = connector;
        this.executorService = executorService;
    }

    public boolean isLogin() {
        Map<String, String> cookies = this.connector.getCookies();
        return cookies.containsKey("email") && cookies.containsKey("password");
    }

    public Request<Void> login(String email, String password) {
        Connection connection = this.connector.connect("https://system.bookscan.co.jp/login.php").method(Connection.Method.POST).data("email", email).data("password", password);
        return new Request<Void>(this.executorService, this.connector, connection){

            @Override
            public Void get() throws BookscanException {
                Document document = this.getDocument();
                if ("https://system.bookscan.co.jp/login.php".equals(document.location())) {
                    throw new BookscanResponseException(document);
                }
                return null;
            }
        };
    }

    public Request<List<Book>> fetchBooks() {
        Connection connection = this.connector.connect("https://system.bookscan.co.jp/bookshelf_all_cover.php").method(Connection.Method.GET);
        return new Request<List<Book>>(this.executorService, this.connector, connection){

            @Override
            public List<Book> get() throws BookscanException {
                Document document = this.getDocument();
                Elements bookLinks = document.select("#sortable_box .showbook");
                ArrayList<Book> books = new ArrayList<Book>();
                for (Element bookLink : bookLinks) {
                    List params;
                    String url = "https://system.bookscan.co.jp/" + bookLink.attr("href");
                    try {
                        params = URLEncodedUtils.parse((URI)new URI(url), (String)UTF8.name());
                    }
                    catch (URISyntaxException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    String filename = null;
                    String hash = null;
                    String digest = null;
                    for (NameValuePair param : params) {
                        switch (param.getName()) {
                            case "f": {
                                filename = param.getValue();
                                break;
                            }
                            case "h": {
                                hash = param.getValue();
                                break;
                            }
                            case "d": {
                                digest = param.getValue();
                            }
                        }
                    }
                    if (filename == null || hash == null || digest == null) continue;
                    Elements imgElement = bookLink.select("img");
                    Book book = imgElement.size() == 0 ? new Book(filename, hash, digest, null) : new Book(filename, hash, digest, imgElement.first().attr("data-original"));
                    books.add(book);
                }
                return books;
            }
        };
    }

    public Request<List<OptimizedBook>> fetchOptimizedBooks() {
        Connection connection = this.connector.connect("https://system.bookscan.co.jp/tunelablist.php").method(Connection.Method.GET);
        return new Request<List<OptimizedBook>>(this.executorService, this.connector, connection){

            @Override
            public List<OptimizedBook> get() throws BookscanException {
                Document document = this.getDocument();
                Elements bookLinks = document.select("a.download");
                ArrayList<OptimizedBook> books = new ArrayList<OptimizedBook>();
                for (Element bookLink : bookLinks) {
                    List params;
                    String url = "https://system.bookscan.co.jp/" + bookLink.attr("href");
                    try {
                        params = URLEncodedUtils.parse((URI)new URI(url), (String)UTF8.name());
                    }
                    catch (URISyntaxException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    String filename = null;
                    String digest = null;
                    for (NameValuePair param : params) {
                        switch (param.getName()) {
                            case "f": {
                                filename = param.getValue();
                                break;
                            }
                            case "d": {
                                digest = param.getValue();
                            }
                        }
                    }
                    if (filename == null || digest == null) continue;
                    books.add(new OptimizedBook(filename, digest));
                }
                return books;
            }
        };
    }

    public Request<Void> requestBookOptimize(final Book book, OptimizeOption option) throws BookscanException {
        String optimizeUrl = book.createOptimizeUrl();
        List<OptimizeOption.Type> types = option.getTypes();
        List<OptimizeOption.Flag> flags = option.getFlags();
        if (types.size() == 0) {
            throw new IllegalArgumentException("Optimize option is not specified");
        }
        List<Connection.KeyVal> hiddenOptions = this.fetchHiddenOptimizeOptions(optimizeUrl);
        Connection connection = this.connector.connect(optimizeUrl).method(Connection.Method.POST);
        for (Connection.KeyVal hiddenOption : hiddenOptions) {
            connection = connection.data(hiddenOption.key(), hiddenOption.value());
        }
        for (OptimizeOption.Type type : types) {
            connection = connection.data("optimize_type[]", type.getValue());
        }
        for (OptimizeOption.Flag flag : flags) {
            connection = connection.data(flag.getInputName(), flag.getValue());
        }
        return new Request<Void>(this.executorService, this.connector, connection){

            @Override
            public Void get() throws BookscanException {
                Document document = this.getDocument();
                if (!book.createOptimizedUrl().equals(document.location())) {
                    throw new BookscanResponseException(document);
                }
                return null;
            }
        };
    }

    public List<Connection.KeyVal> fetchHiddenOptimizeOptions(String optimizeUrl) throws BookscanNetworkException {
        Connection connection = this.connector.connect(optimizeUrl).method(Connection.Method.GET);
        try {
            Document document = this.connector.execute(connection);
            Elements inputs = document.select("input");
            ArrayList<Connection.KeyVal> keyVals = new ArrayList<Connection.KeyVal>();
            for (Element input : inputs) {
                if (!input.attr("type").equals("hidden")) continue;
                String name = input.attr("name");
                String value = input.attr("value");
                keyVals.add((Connection.KeyVal)HttpConnection.KeyVal.create((String)name, (String)value));
            }
            return keyVals;
        }
        catch (IOException e) {
            throw new BookscanNetworkException(e);
        }
    }

    public Request<List<OptimizingBook>> fetchOptimizingBooks() {
        Connection connection = this.connector.connect("https://system.bookscan.co.jp/tunelabnowlist.php").method(Connection.Method.GET);
        return new Request<List<OptimizingBook>>(this.executorService, this.connector, connection){

            @Override
            public List<OptimizingBook> get() throws BookscanException {
                Document document = this.getDocument();
                Elements typeLabels = document.getElementsContainingOwnText("\u30c1\u30e5\u30fc\u30cb\u30f3\u30b0\u30bf\u30a4\u30d7:");
                ArrayList<OptimizingBook> books = new ArrayList<OptimizingBook>();
                for (Element typeLabel : typeLabels) {
                    Element container = typeLabel.parent();
                    String text = container.text();
                    Matcher matcher = OPTIMIZING_BOOK_PATTERN.matcher(text);
                    if (!matcher.find()) continue;
                    String file = matcher.group(1).trim();
                    String type = matcher.group(2).trim();
                    String requestedAt = matcher.group(3).trim();
                    String status = matcher.group(4).trim();
                    OptimizingBook book = new OptimizingBook(file, type, requestedAt, status);
                    books.add(book);
                }
                return books;
            }
        };
    }

    public Map<String, String> getCookies() {
        return this.connector.getCookies();
    }

    public void putCookies(Map<String, String> cookies) {
        this.connector.putCookies(cookies);
    }

    public void clearCookies() {
        this.connector.clearCookies();
    }
}

