/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.bookscan.model;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class Book {
    private String filename;
    private String hash;
    private String digest;
    private String imageUrl;

    public Book() {
    }

    public Book(String filename, String hash, String digest, String imageUrl) {
        this.filename = filename;
        this.hash = hash;
        this.digest = digest;
        this.imageUrl = imageUrl;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public String createDownloadUrl() {
        try {
            StringBuilder builder = new StringBuilder("https://system.bookscan.co.jp/download.php");
            builder.append("?d=").append(this.digest);
            builder.append("&f=").append(URLEncoder.encode(this.filename, "UTF-8"));
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String createOptimizeUrl() {
        try {
            StringBuilder builder = new StringBuilder("https://system.bookscan.co.jp/bookoptimize.php");
            builder.append("?hash=").append(this.hash);
            builder.append("&d=").append(this.digest);
            builder.append("&filename=").append(URLEncoder.encode(this.filename, "UTF-8"));
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String createOptimizedUrl() {
        StringBuilder builder = new StringBuilder("https://system.bookscan.co.jp/bookoptimize_end.php");
        builder.append("?hash=").append(this.hash);
        return builder.toString();
    }
}

