/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.bookscan.reqeust;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.hogel.bookscan.Connector;
import org.hogel.bookscan.exception.BookscanException;
import org.hogel.bookscan.exception.BookscanNetworkException;
import org.hogel.bookscan.reqeust.RequestErrorListener;
import org.hogel.bookscan.reqeust.RequestListener;
import org.jsoup.Connection;
import org.jsoup.nodes.Document;

public abstract class Request<T> {
    private final ExecutorService executorService;
    private final Connector connector;
    private final Connection connection;
    private RequestListener<T> listener;
    private RequestErrorListener requestErrorListener;

    public Request(ExecutorService executorService, Connector connector, Connection connection) {
        this.executorService = executorService;
        this.connector = connector;
        this.connection = connection;
    }

    public abstract T get() throws BookscanException;

    public Document getDocument() throws BookscanNetworkException {
        try {
            return this.connector.execute(this.connection);
        }
        catch (IOException e) {
            throw new BookscanNetworkException(e);
        }
    }

    public Request<T> listener(RequestListener<T> listener) {
        this.listener = listener;
        return this;
    }

    public Request<T> error(RequestErrorListener requestErrorListener) {
        this.requestErrorListener = requestErrorListener;
        return this;
    }

    public Request<T> timeout(int timeout) {
        this.connection.timeout(timeout);
        return this;
    }

    public void execute() {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        Object result = Request.this.get();
                        if (Request.this.listener != null) {
                            Request.this.listener.success(result);
                        }
                    }
                    catch (BookscanException e) {
                        if (Request.this.requestErrorListener == null) break block3;
                        Request.this.requestErrorListener.error(e);
                    }
                }
            }
        });
    }
}

