/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.android.linechartview;

import android.content.Context;
import android.text.format.DateFormat;
import java.util.List;
import org.hogel.android.linechartview.LineChartStyle;
import org.hogel.android.linechartview.LineChartView;

public class DateLineChartView
extends LineChartView {
    private static final long HALF_DAY = 43200000L;
    private static final long A_DAY = 86400000L;

    public DateLineChartView(Context context, List<LineChartView.Point> points) {
        this(context, points, new LineChartStyle());
    }

    public DateLineChartView(Context context, List<LineChartView.Point> points, LineChartStyle lineChartStyle) {
        super(context, points, lineChartStyle);
    }

    @Override
    protected String formatXLabel(long x) {
        if (this.lineChartStyle.getXLabelFormatter() != null) {
            return this.lineChartStyle.getXLabelFormatter().format(x);
        }
        return DateFormat.format((CharSequence)"yyyy/M/d", (long)x).toString();
    }

    @Override
    protected long getMinX() {
        return this.getRawMinX() - 43200000L;
    }

    @Override
    protected long getMaxX() {
        return this.getRawMaxX() + 43200000L;
    }

    @Override
    protected long getMinY() {
        return 0L;
    }

    @Override
    public long getXGridUnit() {
        if (this.manualXGridUnit != null) {
            return this.manualXGridUnit;
        }
        return 86400000L;
    }
}

