/*
 * Decompiled with CFR 0.152.
 */
package org.hogel.android.linechartview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.Shape;
import android.view.View;
import java.util.Iterator;
import java.util.List;
import org.hogel.android.linechartview.LineChartStyle;

public class LineChartView
extends View {
    protected final List<Point> points;
    protected final Paint paint = new Paint();
    protected final Paint labelPaint = new Paint();
    protected final Paint framePaint = new Paint();
    protected final ShapeDrawable chartDrawable;
    protected final ShapeDrawable yLabelDrawable;
    protected final ShapeDrawable xLabelDrawable;
    protected final LineChartStyle lineChartStyle;
    protected Long manualXGridUnit = null;
    protected Long manualYGridUnit = null;
    protected long yLabelWidth = 0L;
    protected long xLabelHeight = 0L;
    protected long chartTopMargin = 0L;
    protected long chartRightMargin = 0L;
    protected List<Long> manualXLabels = null;
    private List<Long> manualYLabels = null;

    public LineChartView(Context context, List<Point> points) {
        this(context, points, new LineChartStyle());
    }

    public LineChartView(Context context, List<Point> points, LineChartStyle lineChartStyle) {
        super(context);
        this.points = points;
        this.lineChartStyle = lineChartStyle;
        this.paint.setAntiAlias(true);
        this.yLabelDrawable = new ShapeDrawable();
        this.xLabelDrawable = new ShapeDrawable();
        this.chartDrawable = new ShapeDrawable();
        this.updateDrawables();
    }

    public void updateDrawables() {
        this.drawXLabels(this.xLabelDrawable);
        this.drawYLabels(this.yLabelDrawable);
        this.drawLineChart(this.chartDrawable);
    }

    protected void onDraw(Canvas canvas) {
        this.yLabelDrawable.draw(canvas);
        this.xLabelDrawable.draw(canvas);
        this.chartDrawable.draw(canvas);
    }

    protected void drawYLabels(ShapeDrawable labelDrawable) {
        Shape labelsShape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                LineChartView.this.labelPaint.setTextAlign(Paint.Align.RIGHT);
                LineChartView.this.labelPaint.setTextSize(LineChartView.this.lineChartStyle.getLabelTextSize());
                LineChartView.this.labelPaint.setColor(LineChartView.this.lineChartStyle.getLabelTextColor());
                long minY = LineChartView.this.getMinY();
                long maxY = LineChartView.this.getMaxY();
                long yrange = maxY - minY;
                int canvasHeight = canvas.getHeight();
                if (LineChartView.this.manualYLabels != null) {
                    Iterator i$ = LineChartView.this.manualYLabels.iterator();
                    while (i$.hasNext()) {
                        long y = (Long)i$.next();
                        String label = LineChartView.this.formatYLabel(y);
                        float yCoordinate = LineChartView.this.getYCoordinate(canvasHeight, y, minY, yrange);
                        canvas.drawText(label, (float)LineChartView.this.yLabelWidth, yCoordinate, LineChartView.this.labelPaint);
                    }
                } else {
                    long yGridUnit = LineChartView.this.getYGridUnit();
                    for (long y = minY; y <= maxY; y += yGridUnit) {
                        String label = LineChartView.this.formatYLabel(y);
                        float yCoordinate = LineChartView.this.getYCoordinate(canvasHeight, y, minY, yrange);
                        canvas.drawText(label, (float)LineChartView.this.yLabelWidth, yCoordinate, LineChartView.this.labelPaint);
                    }
                }
            }
        };
        this.measureYLabel();
        labelDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        labelDrawable.setShape(labelsShape);
    }

    protected void measureYLabel() {
        this.labelPaint.setTextAlign(Paint.Align.RIGHT);
        this.labelPaint.setTextSize(this.lineChartStyle.getLabelTextSize());
        long minY = this.getMinY();
        long maxY = this.getMaxY();
        long yGridUnit = this.getYGridUnit();
        this.yLabelWidth = 0L;
        this.chartTopMargin = 0L;
        Rect textBounds = new Rect();
        for (long y = minY; y <= maxY; y += yGridUnit) {
            String label = this.formatYLabel(y);
            this.labelPaint.getTextBounds(label, 0, label.length(), textBounds);
            if ((long)textBounds.width() > this.yLabelWidth) {
                this.yLabelWidth = textBounds.width();
            }
            this.chartTopMargin = textBounds.height();
        }
    }

    protected String formatYLabel(long y) {
        if (this.lineChartStyle.getYLabelFormatter() != null) {
            return this.lineChartStyle.getYLabelFormatter().format(y);
        }
        return String.format("%,d", y);
    }

    protected void drawXLabels(ShapeDrawable labelDrawable) {
        Shape labelsShape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                LineChartView.this.labelPaint.setTextAlign(Paint.Align.CENTER);
                LineChartView.this.labelPaint.setTextSize(LineChartView.this.lineChartStyle.getLabelTextSize());
                LineChartView.this.labelPaint.setColor(LineChartView.this.lineChartStyle.getLabelTextColor());
                long minX = LineChartView.this.getMinX();
                long maxX = LineChartView.this.getMaxX();
                long xGridUnit = LineChartView.this.getXGridUnit();
                long xrange = maxX - minX;
                int canvasWidth = canvas.getWidth();
                int canvasHeight = canvas.getHeight();
                if (LineChartView.this.manualXLabels != null) {
                    for (long x : LineChartView.this.manualXLabels) {
                        String label = LineChartView.this.formatXLabel(x);
                        float xCoordinate = LineChartView.this.getXCoordinate(canvasWidth, x, minX, xrange);
                        canvas.drawText(label, xCoordinate, (float)canvasHeight, LineChartView.this.labelPaint);
                    }
                } else {
                    for (long x = LineChartView.this.getRawMinX(); x <= maxX; x += xGridUnit) {
                        String label = LineChartView.this.formatXLabel(x);
                        float xCoordinate = LineChartView.this.getXCoordinate(canvasWidth, x, minX, xrange);
                        canvas.drawText(label, xCoordinate, (float)canvasHeight, LineChartView.this.labelPaint);
                    }
                }
            }
        };
        this.measureXLabel();
        labelDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        labelDrawable.setShape(labelsShape);
    }

    protected void measureXLabel() {
        this.labelPaint.setTextAlign(Paint.Align.CENTER);
        this.labelPaint.setTextSize(this.lineChartStyle.getLabelTextSize());
        long minX = this.getRawMinX();
        long maxX = this.getMaxX();
        long xGridUnit = this.getXGridUnit();
        this.xLabelHeight = 0L;
        this.chartRightMargin = 0L;
        Rect textBounds = new Rect();
        for (long x = minX; x <= maxX; x += xGridUnit) {
            String label = this.formatXLabel(x);
            this.labelPaint.getTextBounds(label, 0, label.length(), textBounds);
            if ((long)textBounds.height() > this.xLabelHeight) {
                this.xLabelHeight = textBounds.height();
            }
            this.chartRightMargin = textBounds.width() / 2;
        }
    }

    protected String formatXLabel(long x) {
        if (this.lineChartStyle.getXLabelFormatter() != null) {
            return this.lineChartStyle.getXLabelFormatter().format(x);
        }
        return String.format("%,d", x);
    }

    protected void drawLineChart(ShapeDrawable chartDrawable) {
        Shape chartShape = new Shape(){

            public void draw(Canvas canvas, Paint paint) {
                long minX = LineChartView.this.getMinX();
                long maxX = LineChartView.this.getMaxX();
                long xrange = maxX - minX;
                long minY = LineChartView.this.getMinY();
                long maxY = LineChartView.this.getMaxY();
                long yrange = maxY - minY;
                int width = canvas.getWidth();
                int height = canvas.getHeight();
                float left = LineChartView.this.getChartLeftMargin();
                float top = LineChartView.this.getChartTopMargin();
                float right = (float)width - LineChartView.this.getChartRightMargin();
                float bottom = (float)height - LineChartView.this.getChartBottomMargin();
                LineChartView.this.drawChartFrame(canvas, left, top, right, bottom);
                LineChartView.this.drawXGrid(canvas, minX, xrange);
                LineChartView.this.drawYGrid(canvas, minY, yrange);
                LineChartView.this.drawChartFrameBorder(canvas, left, top, right, bottom);
                LineChartView.this.drawLines(canvas, minX, xrange, minY, yrange);
                if (LineChartView.this.lineChartStyle.isDrawPoint()) {
                    LineChartView.this.drawPoints(canvas, minX, xrange, minY, yrange);
                }
            }
        };
        chartDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
        chartDrawable.setShape(chartShape);
    }

    protected void drawChartFrame(Canvas canvas, float left, float top, float right, float bottom) {
        canvas.save();
        canvas.clipRect(left, top, right, bottom);
        canvas.drawColor(this.lineChartStyle.getBackgroundColor());
        canvas.restore();
    }

    protected void drawChartFrameBorder(Canvas canvas, float left, float top, float right, float bottom) {
        this.framePaint.setColor(this.lineChartStyle.getFrameBorderColor());
        this.framePaint.setStrokeWidth(this.lineChartStyle.getFrameBorderWidth());
        LineChartStyle.Border border = this.lineChartStyle.getFrameBorder();
        if (border.left()) {
            canvas.drawLine(left, top, left, bottom, this.framePaint);
        }
        if (border.top()) {
            canvas.drawLine(left, top, right, top, this.framePaint);
        }
        if (border.right()) {
            canvas.drawLine(right, top, right, bottom, this.framePaint);
        }
        if (border.bottom()) {
            canvas.drawLine(left, bottom, right, bottom, this.framePaint);
        }
    }

    protected float getChartLeftMargin() {
        return (float)this.yLabelWidth + this.lineChartStyle.getYLabelMargin();
    }

    protected float getChartTopMargin() {
        return this.chartTopMargin;
    }

    protected float getChartRightMargin() {
        return this.chartRightMargin;
    }

    protected float getChartBottomMargin() {
        return (float)this.xLabelHeight + this.lineChartStyle.getXLabelMargin();
    }

    protected long getMinX() {
        return this.getRawMinX();
    }

    protected long getRawMinX() {
        return this.points.get(0).getX();
    }

    protected long getMaxX() {
        return this.getRawMaxX();
    }

    protected long getRawMaxX() {
        return this.points.get(this.points.size() - 1).getX();
    }

    protected float getXCoordinate(int canvasWidth, Point point, long minX, long xrange) {
        return this.getXCoordinate(canvasWidth, point.getX(), minX, xrange);
    }

    protected float getXCoordinate(int canvasWidth, long x, long minX, long xrange) {
        return this.getXCoordinate(canvasWidth, x, minX, xrange, true);
    }

    protected float getXCoordinate(int canvasWidth, long x, long minX, long xrange, boolean inChartArea) {
        if (inChartArea) {
            float left = this.getChartLeftMargin();
            float right = this.getChartRightMargin();
            float margin = left + right;
            return ((float)canvasWidth - margin) * (float)(x - minX) * 1.0f / (float)xrange + left;
        }
        return (float)((long)canvasWidth * (x - minX)) * 1.0f / (float)xrange;
    }

    protected long getMinY() {
        return 0L;
    }

    protected long getMaxY() {
        long rawMaxY = this.getRawMaxY();
        long step = this.getStep(rawMaxY);
        return (rawMaxY / step + 1L) * step;
    }

    protected long getRawMaxY() {
        long maxY = Long.MIN_VALUE;
        for (Point point : this.points) {
            long y = point.getY();
            if (y <= maxY) continue;
            maxY = y;
        }
        return maxY;
    }

    protected long getStep(long maxValue) {
        int digits = String.valueOf(maxValue).length();
        return (long)Math.pow(10.0, digits - 1);
    }

    protected float getYCoordinate(int canvasHeight, Point point, long minY, long yrange) {
        return this.getYCoordinate(canvasHeight, point.getY(), minY, yrange);
    }

    protected float getYCoordinate(int canvasHeight, long y, long minY, long yrange) {
        return this.getYCoordinate(canvasHeight, y, minY, yrange, true);
    }

    protected float getYCoordinate(int canvasHeight, long y, long minY, long yrange, boolean inChartArea) {
        if (inChartArea) {
            float top = this.getChartTopMargin();
            float bottom = this.getChartBottomMargin();
            float margin = top + bottom;
            return ((float)canvasHeight - margin) * (1.0f - (float)(y - minY) * 1.0f / (float)yrange) + top;
        }
        return (float)canvasHeight * (1.0f - (float)(y - minY) * 1.0f / (float)yrange);
    }

    protected void drawXGrid(Canvas canvas, long minX, long xrange) {
        long rawMinX = this.getRawMinX();
        long rawMaxX = this.getRawMaxX();
        long xGridUnit = this.getXGridUnit();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        float top = this.getChartTopMargin();
        float bottom = (float)canvasHeight - this.getChartBottomMargin();
        this.paint.setColor(this.lineChartStyle.getGridColor());
        this.paint.setStrokeWidth(this.lineChartStyle.getGridWidth());
        for (long x = rawMinX; x <= rawMaxX; x += xGridUnit) {
            float xCoordinate = this.getXCoordinate(canvasWidth, x, minX, xrange);
            canvas.drawLine(xCoordinate, bottom, xCoordinate, top, this.paint);
        }
    }

    protected void drawYGrid(Canvas canvas, long minY, long yrange) {
        long yGridUnit = this.getYGridUnit();
        long maxY = this.getMaxY();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        float left = this.getChartLeftMargin();
        float right = (float)canvasWidth - this.getChartRightMargin();
        this.paint.setColor(this.lineChartStyle.getGridColor());
        this.paint.setStrokeWidth(this.lineChartStyle.getGridWidth());
        for (long y = 0L; y <= maxY; y += yGridUnit) {
            float yCoordinate = this.getYCoordinate(canvasHeight, y, minY, yrange);
            canvas.drawLine(left, yCoordinate, right, yCoordinate, this.paint);
        }
    }

    protected void drawLines(Canvas canvas, long minX, long xrange, long minY, long yrange) {
        Point prevPoint = null;
        float px = 0.0f;
        float py = 0.0f;
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        this.paint.setColor(this.lineChartStyle.getLineColor());
        this.paint.setStrokeWidth(this.lineChartStyle.getLineWidth());
        for (Point point : this.points) {
            float x = this.getXCoordinate(canvasWidth, point, minX, xrange);
            float y = this.getYCoordinate(canvasHeight, point, minY, yrange);
            if (prevPoint != null) {
                canvas.drawLine(px, py, x, y, this.paint);
            }
            prevPoint = point;
            px = x;
            py = y;
        }
    }

    protected void drawPoints(Canvas canvas, long minX, long xrange, long minY, long yrange) {
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        for (Point point : this.points) {
            float x = this.getXCoordinate(canvasWidth, point, minX, xrange);
            float y = this.getYCoordinate(canvasHeight, point, minY, yrange);
            this.paint.setColor(this.lineChartStyle.getLineColor());
            canvas.drawCircle(x, y, this.lineChartStyle.getPointSize(), this.paint);
            if (!this.lineChartStyle.isDrawPointCenter()) continue;
            this.paint.setColor(this.lineChartStyle.getBackgroundColor());
            canvas.drawCircle(x, y, this.lineChartStyle.getPointCenterSize(), this.paint);
        }
    }

    public void setXGridUnit(long xGridUnit) {
        this.manualXGridUnit = xGridUnit;
        this.updateDrawables();
    }

    public long getXGridUnit() {
        if (this.manualXGridUnit != null) {
            return this.manualXGridUnit;
        }
        long rawMaxX = this.getRawMaxX();
        long xStep = this.getStep(rawMaxX);
        return xStep >= 10L ? xStep / 2L : xStep;
    }

    public void setYGridUnit(long yGridUnit) {
        this.manualYGridUnit = yGridUnit;
        this.updateDrawables();
    }

    public long getYGridUnit() {
        if (this.manualYGridUnit != null) {
            return this.manualYGridUnit;
        }
        long rawMaxY = this.getRawMaxY();
        long yStep = this.getStep(rawMaxY);
        return yStep >= 10L ? yStep / 2L : yStep;
    }

    public void setXLabels(List<Long> labels) {
        this.manualXLabels = labels;
        this.updateDrawables();
    }

    public void setYLabels(List<Long> labels) {
        this.manualYLabels = labels;
        this.updateDrawables();
    }

    public static class Point {
        private long x;
        private long y;

        public Point() {
        }

        public Point(long x, long y) {
            this.x = x;
            this.y = y;
        }

        public long getX() {
            return this.x;
        }

        public void setX(long x) {
            this.x = x;
        }

        public long getY() {
            return this.y;
        }

        public void setY(long y) {
            this.y = y;
        }
    }
}

