/*
 * Decompiled with CFR 0.152.
 */
package org.holer.common.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolerUtil {
    private static Logger log = LoggerFactory.getLogger(HolerUtil.class);

    public static <T> String toJson(T instance) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(instance);
        }
        catch (Exception e) {
            log.debug("Write object [" + instance + "] as json string failed.", (Throwable)e);
            return "";
        }
    }

    public static <T> T toObject(String json, Class<T> clas) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(json, clas);
        }
        catch (Exception e) {
            log.error("Failed to change json text [" + json + "] to object.", (Throwable)e);
            return null;
        }
    }

    public static <T> T toObject(String json, TypeToken<T> typeToken) {
        try {
            Gson gson = new Gson();
            return (T)gson.fromJson(json, typeToken.getType());
        }
        catch (Exception e) {
            log.debug("Change JSON to object failed.", (Throwable)e);
            return null;
        }
    }

    public static <T> void toJsonFile(File jf, T instance) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            mapper.writerWithDefaultPrettyPrinter().writeValue(jf, instance);
        }
        catch (Exception e) {
            log.error("Change object [" + instance + "] to json file [" + jf.getName() + "] failed.", (Throwable)e);
        }
    }

    public static void close(InputStream is) {
        if (null == is) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(Channel channel) {
        if (null == channel) {
            return;
        }
        try {
            channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(ChannelHandlerContext ctx) {
        if (null == ctx) {
            return;
        }
        try {
            HolerUtil.close(ctx.channel());
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String division(long a, long b) {
        double num = (double)a / (double)b;
        DecimalFormat df = new DecimalFormat("0.0");
        String result = df.format(num);
        return result;
    }

    public static void exec(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            log.error("Failed to execute command: " + cmd, (Throwable)e);
        }
    }

    public static boolean isActive(Channel ch) {
        if (null == ch) {
            return false;
        }
        return ch.isActive() || ch.isOpen();
    }
}

