/*
 * Decompiled with CFR 0.152.
 */
package org.holer.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.holer.common.util.HolerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLCreator {
    private static Logger log = LoggerFactory.getLogger(SSLCreator.class);
    private HolerConfig config = HolerConfig.getConfig();
    private SSLContext sslCtx = null;
    private String jksPath = null;
    private static SSLCreator creator = null;

    public static SSLCreator getCreator() {
        if (null == creator) {
            creator = new SSLCreator();
        }
        return creator;
    }

    public static SSLCreator getCreator(String jksPath) {
        if (null == creator) {
            creator = new SSLCreator(jksPath);
        }
        return creator;
    }

    public SSLCreator() {
        this.sslCtx = this.init();
    }

    public SSLCreator(String jksPath) {
        this.jksPath = jksPath;
        this.sslCtx = this.init();
    }

    public SSLContext getSSLContext() {
        return this.sslCtx;
    }

    private InputStream loadJks(String jksPath) throws FileNotFoundException {
        ClassLoader loader = SSLCreator.class.getClassLoader();
        URL ju = loader.getResource(jksPath);
        if (null != ju) {
            log.info("Starting with jks file: {}.", (Object)jksPath);
            return loader.getResourceAsStream(jksPath);
        }
        log.warn("No keystore has been found in the bundled resources. Scanning filesystem...");
        File jf = new File(jksPath);
        if (jf.exists()) {
            log.info("Loading external keystore. jks file: {}.", (Object)jksPath);
            return new FileInputStream(jf);
        }
        log.warn("The keystore file does not exist. jks file: {}.", (Object)jksPath);
        return null;
    }

    public SSLContext init() {
        String jks = this.config.strValue("HOLER_SSL_JKS", "conf/holer.jks");
        if (StringUtils.isNotBlank((String)this.jksPath)) {
            jks = this.jksPath;
        }
        String sslPaswd = this.config.strValue("HOLER_SSL_PASSWORD", "Wisdom-Holer");
        try {
            log.info("Loading keystore. Keystore path: {}.", (Object)jks);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(this.loadJks(jks), sslPaswd.toCharArray());
            log.info("Initializing key manager...");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, sslPaswd.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            log.info("Initializing SSL context...");
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            log.info("The SSL context has been initialized successfully.");
            return sslCtx;
        }
        catch (Exception e) {
            log.error("Unable to initialize SSL context. Cause: {}, error message: {}.", (Object)e.getCause(), (Object)e.getMessage());
            return null;
        }
    }
}

