/*
 * Decompiled with CFR 0.152.
 */
package org.holer.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.holer.common.util.HolerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolerConfig {
    private static Logger log = LoggerFactory.getLogger(HolerConfig.class);
    private static HolerConfig config = null;
    private Properties holerConf = new Properties();

    public static HolerConfig getConfig() {
        if (null == config) {
            config = new HolerConfig();
        }
        return config;
    }

    public HolerConfig() {
        this.initConfig("conf/holer.conf");
        this.initConfig("holer.conf");
    }

    public void initConfig(String confFile) {
        InputStream is;
        block5: {
            is = null;
            is = HolerConfig.class.getClassLoader().getResourceAsStream(confFile);
            if (null != is) break block5;
            log.warn("Can not find configuration file: " + confFile);
            HolerUtil.close(is);
            return;
        }
        try {
            this.holerConf.load(is);
        }
        catch (IOException e) {
            try {
                log.error("Failed to load configuration file.");
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                HolerUtil.close(is);
                throw throwable;
            }
        }
        HolerUtil.close(is);
    }

    public String strValue(String key) {
        String value = this.holerConf.getProperty(key);
        return StringUtils.trim((String)value);
    }

    public String strValue(String key, String defaultValue) {
        String value = this.strValue(key);
        if (StringUtils.isBlank((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public Integer intValue(String key) {
        String value = this.strValue(key);
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        if (StringUtils.isNumeric((String)value)) {
            return Integer.valueOf(value);
        }
        return null;
    }

    public int intValue(String key, int defaultValue) {
        Integer value = this.intValue(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public Boolean boolValue(String key) {
        String value = this.strValue(key);
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (!value.equals(Boolean.toString(false)) && !value.equals(Boolean.toString(true))) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public boolean boolValue(String key, Boolean defaultValue) {
        Boolean value = this.boolValue(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }
}

