// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package org.holochain.androidserviceruntime.holochain_service_client

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Callback
import com.sun.jna.Library
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicLong

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0

    @JvmField var len: Long = 0

    @JvmField var data: Pointer? = null

    class ByValue :
        RustBuffer(),
        Structure.ByValue

    class ByReference :
        RustBuffer(),
        Structure.ByReference

    internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) =
            uniffiRustCall { status ->
                // Note: need to convert the size to a `Long` value to make this work with JVM.
                UniffiLib.INSTANCE.ffi_holochain_conductor_runtime_types_ffi_rustbuffer_alloc(size.toLong(), status)
            }.also {
                if (it.data == null) {
                    throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=$size)")
                }
            }

        fun create(
            capacity: ULong,
            len: ULong,
            data: Pointer?,
        ): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) =
            uniffiRustCall { status ->
                UniffiLib.INSTANCE.ffi_holochain_conductor_runtime_types_ffi_rustbuffer_free(buf, status)
            }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0

    @JvmField var data: Pointer? = null

    class ByValue :
        ForeignBytes(),
        Structure.ByValue
}

/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(
        value: KotlinType,
        buf: ByteBuffer,
    )

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf =
                rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                    it.order(ByteOrder.BIG_ENDIAN)
                }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
            val item = read(byteBuf)
            if (byteBuf.hasRemaining()) {
                throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
            }
            return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType> : FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)

    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0

    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue :
        UniffiRustCallStatus(),
        Structure.ByValue

    fun isSuccess(): Boolean = code == UNIFFI_CALL_SUCCESS

    fun isError(): Boolean = code == UNIFFI_CALL_ERROR

    fun isPanic(): Boolean = code == UNIFFI_CALL_UNEXPECTED_ERROR

    companion object {
        fun create(
            code: Byte,
            errorBuf: RustBuffer.ByValue,
        ): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(
    message: String,
) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E : kotlin.Exception> uniffiRustCallWithError(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    callback: (UniffiRustCallStatus) -> U,
): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun <E : kotlin.Exception> uniffiCheckCallStatus(
    errorHandler: UniffiRustCallStatusErrorHandler<E>,
    status: UniffiRustCallStatus,
) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler : UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U =
    uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)

internal inline fun <T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch (e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun <T, reified E : Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue,
) {
    try {
        writeReturn(makeCall())
    } catch (e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}

// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T : Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter =
        java.util.concurrent.atomic
            .AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T = map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T = map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "holochain_conductor_runtime_types_ffi"
}

private inline fun <reified Lib : Library> loadIndirect(componentName: String): Lib =
    Native.load<Lib>(findLibraryName(componentName), Lib::class.java)

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(
        `data`: Long,
        `pollResult`: Byte,
    )
}

internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long)
}

internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long)
}

@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ) : UniffiForeignFuture(`handle`, `free`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructU8(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructU8.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructI8(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructI8.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructU16(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructU16.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructI16(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructI16.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructU32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructU32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructI32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructI32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructU64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructU64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructI64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructI64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructF32(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructF32.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructF64(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructF64.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructPointer(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructPointer.UniffiByValue,
    )
}

@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructRustBuffer(`returnValue`, `callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,
    )
}

@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ) : UniffiForeignFutureStructVoid(`callStatus`),
        Structure.ByValue

    internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }
}

internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(
        `callbackData`: Long,
        `result`: UniffiForeignFutureStructVoid.UniffiByValue,
    )
}

// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is
// rather `InterfaceTooLargeException`, caused by too many methods
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib
// * IntegrityCheckingUniffiLib (this)
// we allow for ~2x as many methods in the UniffiLib interface.
//
// The `ffi_uniffi_contract_version` method and all checksum methods are put
// into `IntegrityCheckingUniffiLib` and these methods are called only once,
// when the library is loaded.
internal interface IntegrityCheckingUniffiLib : Library {
    // Integrity check functions only
    fun ffi_holochain_conductor_runtime_types_ffi_uniffi_contract_version(): Int
}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            val componentName = "holochain_conductor_runtime_types_ffi"
            // For large crates we prevent `MethodTooLargeException` (see #2340)
            // N.B. the name of the extension is very misleading, since it is
            // rather `InterfaceTooLargeException`, caused by too many methods
            // in the interface for large crates.
            //
            // By splitting the otherwise huge interface into two parts
            // * UniffiLib (this)
            // * IntegrityCheckingUniffiLib
            // And all checksum methods are put into `IntegrityCheckingUniffiLib`
            // we allow for ~2x as many methods in the UniffiLib interface.
            //
            // Thus we first load the library with `loadIndirect` as `IntegrityCheckingUniffiLib`
            // so that we can (optionally!) call `uniffiCheckApiChecksums`...
            loadIndirect<IntegrityCheckingUniffiLib>(componentName)
                .also { lib: IntegrityCheckingUniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                }
            // ... and then we load the library as `UniffiLib`
            // N.B. we cannot use `loadIndirect` once and then try to cast it to `UniffiLib`
            // => results in `java.lang.ClassCastException: com.sun.proxy.$Proxy cannot be cast to ...`
            // error. So we must call `loadIndirect` twice. For crates large enough
            // to trigger this issue, the performance impact is negligible, running on
            // a macOS M1 machine the `loadIndirect` call takes ~50ms.
            val lib = loadIndirect<UniffiLib>(componentName)
            // No need to check the contract version and checksums, since
            // we already did that with `IntegrityCheckingUniffiLib` above.
            // Loading of library with integrity check done.
            lib
        }
    }

    // FFI functions
    fun ffi_holochain_conductor_runtime_types_ffi_rustbuffer_alloc(
        `size`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_holochain_conductor_runtime_types_ffi_rustbuffer_from_bytes(
        `bytes`: ForeignBytes.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_holochain_conductor_runtime_types_ffi_rustbuffer_free(
        `buf`: RustBuffer.ByValue,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rustbuffer_reserve(
        `buf`: RustBuffer.ByValue,
        `additional`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_u8(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_u8(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_u8(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_u8(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_i8(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_i8(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_i8(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_i8(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Byte

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_u16(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_u16(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_u16(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_u16(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_i16(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_i16(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_i16(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_i16(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Short

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_u32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_u32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_u32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_u32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_i32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_i32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_i32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_i32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Int

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_u64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_u64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_u64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_u64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_i64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_i64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_i64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_i64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Long

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_f32(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_f32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_f32(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_f32(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Float

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_f64(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_f64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_f64(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_f64(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Double

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_pointer(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_pointer(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_pointer(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_pointer(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Pointer

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_rust_buffer(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_rust_buffer(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_rust_buffer(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_rust_buffer(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_poll_void(
        `handle`: Long,
        `callback`: UniffiRustFutureContinuationCallback,
        `callbackData`: Long,
    ): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_cancel_void(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_free_void(`handle`: Long): Unit

    fun ffi_holochain_conductor_runtime_types_ffi_rust_future_complete_void(
        `handle`: Long,
        uniffi_out_err: UniffiRustCallStatus,
    ): Unit
}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_holochain_conductor_runtime_types_ffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    UniffiLib.INSTANCE
}

// Async support

// Public interface members begin here.

// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()

    companion object {
        fun destroy(vararg args: Any?) {
            args
                .filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/**
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer

/**
 * @suppress
 */
public object FfiConverterUShort : FfiConverter<UShort, Short> {
    override fun lift(value: Short): UShort = value.toUShort()

    override fun read(buf: ByteBuffer): UShort = lift(buf.getShort())

    override fun lower(value: UShort): Short = value.toShort()

    override fun allocationSize(value: UShort) = 2UL

    override fun write(
        value: UShort,
        buf: ByteBuffer,
    ) {
        buf.putShort(value.toShort())
    }
}

/**
 * @suppress
 */
public object FfiConverterUInt : FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt = value.toUInt()

    override fun read(buf: ByteBuffer): UInt = lift(buf.getInt())

    override fun lower(value: UInt): Int = value.toInt()

    override fun allocationSize(value: UInt) = 4UL

    override fun write(
        value: UInt,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterULong : FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong = value.toULong()

    override fun read(buf: ByteBuffer): ULong = lift(buf.getLong())

    override fun lower(value: ULong): Long = value.toLong()

    override fun allocationSize(value: ULong) = 8UL

    override fun write(
        value: ULong,
        buf: ByteBuffer,
    ) {
        buf.putLong(value.toLong())
    }
}

/**
 * @suppress
 */
public object FfiConverterLong : FfiConverter<Long, Long> {
    override fun lift(value: Long): Long = value

    override fun read(buf: ByteBuffer): Long = buf.getLong()

    override fun lower(value: Long): Long = value

    override fun allocationSize(value: Long) = 8UL

    override fun write(
        value: Long,
        buf: ByteBuffer,
    ) {
        buf.putLong(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean : FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean = value.toInt() != 0

    override fun read(buf: ByteBuffer): Boolean = lift(buf.get())

    override fun lower(value: Boolean): Byte = if (value) 1.toByte() else 0.toByte()

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(
        value: Boolean,
        buf: ByteBuffer,
    ) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString : FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(
        value: String,
        buf: ByteBuffer,
    ) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

/**
 * @suppress
 */
public object FfiConverterByteArray : FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }

    override fun allocationSize(value: ByteArray): ULong = 4UL + value.size.toULong()

    override fun write(
        value: ByteArray,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        buf.put(value)
    }
}

data class AppAuthFfi(
    var `authentication`: AppAuthenticationTokenIssuedFfi,
    var `port`: kotlin.UShort,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeAppAuthFfi : FfiConverterRustBuffer<AppAuthFfi> {
    override fun read(buf: ByteBuffer): AppAuthFfi =
        AppAuthFfi(
            FfiConverterTypeAppAuthenticationTokenIssuedFfi.read(buf),
            FfiConverterUShort.read(buf),
        )

    override fun allocationSize(value: AppAuthFfi) =
        (
            FfiConverterTypeAppAuthenticationTokenIssuedFfi.allocationSize(value.`authentication`) +
                FfiConverterUShort.allocationSize(value.`port`)
        )

    override fun write(
        value: AppAuthFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeAppAuthenticationTokenIssuedFfi.write(value.`authentication`, buf)
        FfiConverterUShort.write(value.`port`, buf)
    }
}

data class AppAuthenticationTokenIssuedFfi(
    var `token`: kotlin.ByteArray,
    var `expiresAt`: kotlin.Long?,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeAppAuthenticationTokenIssuedFfi : FfiConverterRustBuffer<AppAuthenticationTokenIssuedFfi> {
    override fun read(buf: ByteBuffer): AppAuthenticationTokenIssuedFfi =
        AppAuthenticationTokenIssuedFfi(
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalLong.read(buf),
        )

    override fun allocationSize(value: AppAuthenticationTokenIssuedFfi) =
        (
            FfiConverterByteArray.allocationSize(value.`token`) +
                FfiConverterOptionalLong.allocationSize(value.`expiresAt`)
        )

    override fun write(
        value: AppAuthenticationTokenIssuedFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterByteArray.write(value.`token`, buf)
        FfiConverterOptionalLong.write(value.`expiresAt`, buf)
    }
}

data class AppInfoFfi(
    /**
     * The unique identifier for an installed app in this conductor
     */
    var `installedAppId`: kotlin.String,
    var `cellInfo`: Map<kotlin.String, List<CellInfoFfi>>,
    var `status`: AppInfoStatusFfi,
    var `agentPubKey`: kotlin.ByteArray,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeAppInfoFfi : FfiConverterRustBuffer<AppInfoFfi> {
    override fun read(buf: ByteBuffer): AppInfoFfi =
        AppInfoFfi(
            FfiConverterString.read(buf),
            FfiConverterMapStringSequenceTypeCellInfoFfi.read(buf),
            FfiConverterTypeAppInfoStatusFfi.read(buf),
            FfiConverterByteArray.read(buf),
        )

    override fun allocationSize(value: AppInfoFfi) =
        (
            FfiConverterString.allocationSize(value.`installedAppId`) +
                FfiConverterMapStringSequenceTypeCellInfoFfi.allocationSize(value.`cellInfo`) +
                FfiConverterTypeAppInfoStatusFfi.allocationSize(value.`status`) +
                FfiConverterByteArray.allocationSize(value.`agentPubKey`)
        )

    override fun write(
        value: AppInfoFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`installedAppId`, buf)
        FfiConverterMapStringSequenceTypeCellInfoFfi.write(value.`cellInfo`, buf)
        FfiConverterTypeAppInfoStatusFfi.write(value.`status`, buf)
        FfiConverterByteArray.write(value.`agentPubKey`, buf)
    }
}

data class CellIdFfi(
    var `dnaHash`: kotlin.ByteArray,
    var `agentPubKey`: kotlin.ByteArray,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCellIdFfi : FfiConverterRustBuffer<CellIdFfi> {
    override fun read(buf: ByteBuffer): CellIdFfi =
        CellIdFfi(
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
        )

    override fun allocationSize(value: CellIdFfi) =
        (
            FfiConverterByteArray.allocationSize(value.`dnaHash`) +
                FfiConverterByteArray.allocationSize(value.`agentPubKey`)
        )

    override fun write(
        value: CellIdFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterByteArray.write(value.`dnaHash`, buf)
        FfiConverterByteArray.write(value.`agentPubKey`, buf)
    }
}

data class ClonedCellFfi(
    var `cellId`: CellIdFfi,
    var `cloneId`: kotlin.String,
    var `originalDnaHash`: kotlin.ByteArray,
    var `dnaModifiers`: DnaModifiersFfi,
    var `name`: kotlin.String,
    var `enabled`: kotlin.Boolean,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeClonedCellFfi : FfiConverterRustBuffer<ClonedCellFfi> {
    override fun read(buf: ByteBuffer): ClonedCellFfi =
        ClonedCellFfi(
            FfiConverterTypeCellIdFfi.read(buf),
            FfiConverterString.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterTypeDnaModifiersFfi.read(buf),
            FfiConverterString.read(buf),
            FfiConverterBoolean.read(buf),
        )

    override fun allocationSize(value: ClonedCellFfi) =
        (
            FfiConverterTypeCellIdFfi.allocationSize(value.`cellId`) +
                FfiConverterString.allocationSize(value.`cloneId`) +
                FfiConverterByteArray.allocationSize(value.`originalDnaHash`) +
                FfiConverterTypeDnaModifiersFfi.allocationSize(value.`dnaModifiers`) +
                FfiConverterString.allocationSize(value.`name`) +
                FfiConverterBoolean.allocationSize(value.`enabled`)
        )

    override fun write(
        value: ClonedCellFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeCellIdFfi.write(value.`cellId`, buf)
        FfiConverterString.write(value.`cloneId`, buf)
        FfiConverterByteArray.write(value.`originalDnaHash`, buf)
        FfiConverterTypeDnaModifiersFfi.write(value.`dnaModifiers`, buf)
        FfiConverterString.write(value.`name`, buf)
        FfiConverterBoolean.write(value.`enabled`, buf)
    }
}

data class DnaModifiersFfi(
    var `networkSeed`: kotlin.String,
    var `properties`: kotlin.ByteArray,
    var `originTime`: kotlin.Long,
    var `quantumTime`: DurationFfi,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDnaModifiersFfi : FfiConverterRustBuffer<DnaModifiersFfi> {
    override fun read(buf: ByteBuffer): DnaModifiersFfi =
        DnaModifiersFfi(
            FfiConverterString.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterLong.read(buf),
            FfiConverterTypeDurationFfi.read(buf),
        )

    override fun allocationSize(value: DnaModifiersFfi) =
        (
            FfiConverterString.allocationSize(value.`networkSeed`) +
                FfiConverterByteArray.allocationSize(value.`properties`) +
                FfiConverterLong.allocationSize(value.`originTime`) +
                FfiConverterTypeDurationFfi.allocationSize(value.`quantumTime`)
        )

    override fun write(
        value: DnaModifiersFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`networkSeed`, buf)
        FfiConverterByteArray.write(value.`properties`, buf)
        FfiConverterLong.write(value.`originTime`, buf)
        FfiConverterTypeDurationFfi.write(value.`quantumTime`, buf)
    }
}

data class DnaModifiersOptFfi(
    var `networkSeed`: kotlin.String?,
    var `properties`: kotlin.ByteArray?,
    var `originTime`: kotlin.Long?,
    var `quantumTime`: DurationFfi?,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDnaModifiersOptFfi : FfiConverterRustBuffer<DnaModifiersOptFfi> {
    override fun read(buf: ByteBuffer): DnaModifiersOptFfi =
        DnaModifiersOptFfi(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterOptionalLong.read(buf),
            FfiConverterOptionalTypeDurationFfi.read(buf),
        )

    override fun allocationSize(value: DnaModifiersOptFfi) =
        (
            FfiConverterOptionalString.allocationSize(value.`networkSeed`) +
                FfiConverterOptionalByteArray.allocationSize(value.`properties`) +
                FfiConverterOptionalLong.allocationSize(value.`originTime`) +
                FfiConverterOptionalTypeDurationFfi.allocationSize(value.`quantumTime`)
        )

    override fun write(
        value: DnaModifiersOptFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterOptionalString.write(value.`networkSeed`, buf)
        FfiConverterOptionalByteArray.write(value.`properties`, buf)
        FfiConverterOptionalLong.write(value.`originTime`, buf)
        FfiConverterOptionalTypeDurationFfi.write(value.`quantumTime`, buf)
    }
}

data class DurationFfi(
    var `secs`: kotlin.ULong,
    var `nanos`: kotlin.UInt,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDurationFfi : FfiConverterRustBuffer<DurationFfi> {
    override fun read(buf: ByteBuffer): DurationFfi =
        DurationFfi(
            FfiConverterULong.read(buf),
            FfiConverterUInt.read(buf),
        )

    override fun allocationSize(value: DurationFfi) =
        (
            FfiConverterULong.allocationSize(value.`secs`) +
                FfiConverterUInt.allocationSize(value.`nanos`)
        )

    override fun write(
        value: DurationFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterULong.write(value.`secs`, buf)
        FfiConverterUInt.write(value.`nanos`, buf)
    }
}

data class InstallAppPayloadFfi(
    /**
     * Raw bytes of encoded AppBundle
     */
    var `source`: kotlin.ByteArray,
    var `installedAppId`: kotlin.String?,
    var `networkSeed`: kotlin.String?,
    var `rolesSettings`: Map<kotlin.String, RoleSettingsFfi>?,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeInstallAppPayloadFfi : FfiConverterRustBuffer<InstallAppPayloadFfi> {
    override fun read(buf: ByteBuffer): InstallAppPayloadFfi =
        InstallAppPayloadFfi(
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalMapStringTypeRoleSettingsFfi.read(buf),
        )

    override fun allocationSize(value: InstallAppPayloadFfi) =
        (
            FfiConverterByteArray.allocationSize(value.`source`) +
                FfiConverterOptionalString.allocationSize(value.`installedAppId`) +
                FfiConverterOptionalString.allocationSize(value.`networkSeed`) +
                FfiConverterOptionalMapStringTypeRoleSettingsFfi.allocationSize(value.`rolesSettings`)
        )

    override fun write(
        value: InstallAppPayloadFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterByteArray.write(value.`source`, buf)
        FfiConverterOptionalString.write(value.`installedAppId`, buf)
        FfiConverterOptionalString.write(value.`networkSeed`, buf)
        FfiConverterOptionalMapStringTypeRoleSettingsFfi.write(value.`rolesSettings`, buf)
    }
}

data class ProvisionedCellFfi(
    var `cellId`: CellIdFfi,
    var `dnaModifiers`: DnaModifiersFfi,
    var `name`: kotlin.String,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeProvisionedCellFfi : FfiConverterRustBuffer<ProvisionedCellFfi> {
    override fun read(buf: ByteBuffer): ProvisionedCellFfi =
        ProvisionedCellFfi(
            FfiConverterTypeCellIdFfi.read(buf),
            FfiConverterTypeDnaModifiersFfi.read(buf),
            FfiConverterString.read(buf),
        )

    override fun allocationSize(value: ProvisionedCellFfi) =
        (
            FfiConverterTypeCellIdFfi.allocationSize(value.`cellId`) +
                FfiConverterTypeDnaModifiersFfi.allocationSize(value.`dnaModifiers`) +
                FfiConverterString.allocationSize(value.`name`)
        )

    override fun write(
        value: ProvisionedCellFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeCellIdFfi.write(value.`cellId`, buf)
        FfiConverterTypeDnaModifiersFfi.write(value.`dnaModifiers`, buf)
        FfiConverterString.write(value.`name`, buf)
    }
}

data class RuntimeConfigFfi(
    /**
     * Path where conductor data is stored
     */
    var `dataRootPath`: kotlin.String,
    /**
     * URL of the bootstrap server
     */
    var `bootstrapUrl`: kotlin.String,
    /**
     * URL of the sbd server
     */
    var `signalUrl`: kotlin.String,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRuntimeConfigFfi : FfiConverterRustBuffer<RuntimeConfigFfi> {
    override fun read(buf: ByteBuffer): RuntimeConfigFfi =
        RuntimeConfigFfi(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )

    override fun allocationSize(value: RuntimeConfigFfi) =
        (
            FfiConverterString.allocationSize(value.`dataRootPath`) +
                FfiConverterString.allocationSize(value.`bootstrapUrl`) +
                FfiConverterString.allocationSize(value.`signalUrl`)
        )

    override fun write(
        value: RuntimeConfigFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterString.write(value.`dataRootPath`, buf)
        FfiConverterString.write(value.`bootstrapUrl`, buf)
        FfiConverterString.write(value.`signalUrl`, buf)
    }
}

data class StemCellFfi(
    var `originalDnaHash`: kotlin.ByteArray,
    var `dnaModifiers`: DnaModifiersFfi,
    var `name`: kotlin.String?,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeStemCellFfi : FfiConverterRustBuffer<StemCellFfi> {
    override fun read(buf: ByteBuffer): StemCellFfi =
        StemCellFfi(
            FfiConverterByteArray.read(buf),
            FfiConverterTypeDnaModifiersFfi.read(buf),
            FfiConverterOptionalString.read(buf),
        )

    override fun allocationSize(value: StemCellFfi) =
        (
            FfiConverterByteArray.allocationSize(value.`originalDnaHash`) +
                FfiConverterTypeDnaModifiersFfi.allocationSize(value.`dnaModifiers`) +
                FfiConverterOptionalString.allocationSize(value.`name`)
        )

    override fun write(
        value: StemCellFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterByteArray.write(value.`originalDnaHash`, buf)
        FfiConverterTypeDnaModifiersFfi.write(value.`dnaModifiers`, buf)
        FfiConverterOptionalString.write(value.`name`, buf)
    }
}

data class ZomeCallFfi(
    var `cellId`: CellIdFfi,
    var `zomeName`: kotlin.String,
    var `fnName`: kotlin.String,
    var `payload`: kotlin.ByteArray,
    var `capSecret`: kotlin.ByteArray?,
    var `provenance`: kotlin.ByteArray,
    var `signature`: kotlin.ByteArray,
    var `nonce`: kotlin.ByteArray,
    var `expiresAt`: kotlin.Long,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZomeCallFfi : FfiConverterRustBuffer<ZomeCallFfi> {
    override fun read(buf: ByteBuffer): ZomeCallFfi =
        ZomeCallFfi(
            FfiConverterTypeCellIdFfi.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterLong.read(buf),
        )

    override fun allocationSize(value: ZomeCallFfi) =
        (
            FfiConverterTypeCellIdFfi.allocationSize(value.`cellId`) +
                FfiConverterString.allocationSize(value.`zomeName`) +
                FfiConverterString.allocationSize(value.`fnName`) +
                FfiConverterByteArray.allocationSize(value.`payload`) +
                FfiConverterOptionalByteArray.allocationSize(value.`capSecret`) +
                FfiConverterByteArray.allocationSize(value.`provenance`) +
                FfiConverterByteArray.allocationSize(value.`signature`) +
                FfiConverterByteArray.allocationSize(value.`nonce`) +
                FfiConverterLong.allocationSize(value.`expiresAt`)
        )

    override fun write(
        value: ZomeCallFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterTypeCellIdFfi.write(value.`cellId`, buf)
        FfiConverterString.write(value.`zomeName`, buf)
        FfiConverterString.write(value.`fnName`, buf)
        FfiConverterByteArray.write(value.`payload`, buf)
        FfiConverterOptionalByteArray.write(value.`capSecret`, buf)
        FfiConverterByteArray.write(value.`provenance`, buf)
        FfiConverterByteArray.write(value.`signature`, buf)
        FfiConverterByteArray.write(value.`nonce`, buf)
        FfiConverterLong.write(value.`expiresAt`, buf)
    }
}

data class ZomeCallUnsignedFfi(
    var `provenance`: kotlin.ByteArray,
    var `cellId`: CellIdFfi,
    var `zomeName`: kotlin.String,
    var `fnName`: kotlin.String,
    var `capSecret`: kotlin.ByteArray?,
    var `payload`: kotlin.ByteArray,
    var `nonce`: kotlin.ByteArray,
    var `expiresAt`: kotlin.Long,
) {
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZomeCallUnsignedFfi : FfiConverterRustBuffer<ZomeCallUnsignedFfi> {
    override fun read(buf: ByteBuffer): ZomeCallUnsignedFfi =
        ZomeCallUnsignedFfi(
            FfiConverterByteArray.read(buf),
            FfiConverterTypeCellIdFfi.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterOptionalByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterByteArray.read(buf),
            FfiConverterLong.read(buf),
        )

    override fun allocationSize(value: ZomeCallUnsignedFfi) =
        (
            FfiConverterByteArray.allocationSize(value.`provenance`) +
                FfiConverterTypeCellIdFfi.allocationSize(value.`cellId`) +
                FfiConverterString.allocationSize(value.`zomeName`) +
                FfiConverterString.allocationSize(value.`fnName`) +
                FfiConverterOptionalByteArray.allocationSize(value.`capSecret`) +
                FfiConverterByteArray.allocationSize(value.`payload`) +
                FfiConverterByteArray.allocationSize(value.`nonce`) +
                FfiConverterLong.allocationSize(value.`expiresAt`)
        )

    override fun write(
        value: ZomeCallUnsignedFfi,
        buf: ByteBuffer,
    ) {
        FfiConverterByteArray.write(value.`provenance`, buf)
        FfiConverterTypeCellIdFfi.write(value.`cellId`, buf)
        FfiConverterString.write(value.`zomeName`, buf)
        FfiConverterString.write(value.`fnName`, buf)
        FfiConverterOptionalByteArray.write(value.`capSecret`, buf)
        FfiConverterByteArray.write(value.`payload`, buf)
        FfiConverterByteArray.write(value.`nonce`, buf)
        FfiConverterLong.write(value.`expiresAt`, buf)
    }
}

sealed class AppInfoStatusFfi {
    data class Paused(
        val `reason`: PausedAppReasonFfi,
    ) : AppInfoStatusFfi() {
        companion object
    }

    data class Disabled(
        val `reason`: DisabledAppReasonFfi,
    ) : AppInfoStatusFfi() {
        companion object
    }

    object Running : AppInfoStatusFfi()

    object AwaitingMemproofs : AppInfoStatusFfi()

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeAppInfoStatusFfi : FfiConverterRustBuffer<AppInfoStatusFfi> {
    override fun read(buf: ByteBuffer): AppInfoStatusFfi =
        when (buf.getInt()) {
            1 ->
                AppInfoStatusFfi.Paused(
                    FfiConverterTypePausedAppReasonFfi.read(buf),
                )
            2 ->
                AppInfoStatusFfi.Disabled(
                    FfiConverterTypeDisabledAppReasonFfi.read(buf),
                )
            3 -> AppInfoStatusFfi.Running
            4 -> AppInfoStatusFfi.AwaitingMemproofs
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }

    override fun allocationSize(value: AppInfoStatusFfi) =
        when (value) {
            is AppInfoStatusFfi.Paused -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypePausedAppReasonFfi.allocationSize(value.`reason`)
                )
            }
            is AppInfoStatusFfi.Disabled -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypeDisabledAppReasonFfi.allocationSize(value.`reason`)
                )
            }
            is AppInfoStatusFfi.Running -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
            is AppInfoStatusFfi.AwaitingMemproofs -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
        }

    override fun write(
        value: AppInfoStatusFfi,
        buf: ByteBuffer,
    ) {
        when (value) {
            is AppInfoStatusFfi.Paused -> {
                buf.putInt(1)
                FfiConverterTypePausedAppReasonFfi.write(value.`reason`, buf)
                Unit
            }
            is AppInfoStatusFfi.Disabled -> {
                buf.putInt(2)
                FfiConverterTypeDisabledAppReasonFfi.write(value.`reason`, buf)
                Unit
            }
            is AppInfoStatusFfi.Running -> {
                buf.putInt(3)
                Unit
            }
            is AppInfoStatusFfi.AwaitingMemproofs -> {
                buf.putInt(4)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

sealed class CellInfoFfi {
    data class Provisioned(
        val v1: ProvisionedCellFfi,
    ) : CellInfoFfi() {
        companion object
    }

    data class Cloned(
        val v1: ClonedCellFfi,
    ) : CellInfoFfi() {
        companion object
    }

    data class Stem(
        val v1: StemCellFfi,
    ) : CellInfoFfi() {
        companion object
    }

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeCellInfoFfi : FfiConverterRustBuffer<CellInfoFfi> {
    override fun read(buf: ByteBuffer): CellInfoFfi =
        when (buf.getInt()) {
            1 ->
                CellInfoFfi.Provisioned(
                    FfiConverterTypeProvisionedCellFfi.read(buf),
                )
            2 ->
                CellInfoFfi.Cloned(
                    FfiConverterTypeClonedCellFfi.read(buf),
                )
            3 ->
                CellInfoFfi.Stem(
                    FfiConverterTypeStemCellFfi.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }

    override fun allocationSize(value: CellInfoFfi) =
        when (value) {
            is CellInfoFfi.Provisioned -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypeProvisionedCellFfi.allocationSize(value.v1)
                )
            }
            is CellInfoFfi.Cloned -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypeClonedCellFfi.allocationSize(value.v1)
                )
            }
            is CellInfoFfi.Stem -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypeStemCellFfi.allocationSize(value.v1)
                )
            }
        }

    override fun write(
        value: CellInfoFfi,
        buf: ByteBuffer,
    ) {
        when (value) {
            is CellInfoFfi.Provisioned -> {
                buf.putInt(1)
                FfiConverterTypeProvisionedCellFfi.write(value.v1, buf)
                Unit
            }
            is CellInfoFfi.Cloned -> {
                buf.putInt(2)
                FfiConverterTypeClonedCellFfi.write(value.v1, buf)
                Unit
            }
            is CellInfoFfi.Stem -> {
                buf.putInt(3)
                FfiConverterTypeStemCellFfi.write(value.v1, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

sealed class DisabledAppReasonFfi {
    object NeverStarted : DisabledAppReasonFfi()

    object NotStartedAfterProvidingMemproofs : DisabledAppReasonFfi()

    object DeletingAgentKey : DisabledAppReasonFfi()

    object User : DisabledAppReasonFfi()

    data class Error(
        val v1: kotlin.String,
    ) : DisabledAppReasonFfi() {
        companion object
    }

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDisabledAppReasonFfi : FfiConverterRustBuffer<DisabledAppReasonFfi> {
    override fun read(buf: ByteBuffer): DisabledAppReasonFfi =
        when (buf.getInt()) {
            1 -> DisabledAppReasonFfi.NeverStarted
            2 -> DisabledAppReasonFfi.NotStartedAfterProvidingMemproofs
            3 -> DisabledAppReasonFfi.DeletingAgentKey
            4 -> DisabledAppReasonFfi.User
            5 ->
                DisabledAppReasonFfi.Error(
                    FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }

    override fun allocationSize(value: DisabledAppReasonFfi) =
        when (value) {
            is DisabledAppReasonFfi.NeverStarted -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
            is DisabledAppReasonFfi.NotStartedAfterProvidingMemproofs -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
            is DisabledAppReasonFfi.DeletingAgentKey -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
            is DisabledAppReasonFfi.User -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL
                )
            }
            is DisabledAppReasonFfi.Error -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterString.allocationSize(value.v1)
                )
            }
        }

    override fun write(
        value: DisabledAppReasonFfi,
        buf: ByteBuffer,
    ) {
        when (value) {
            is DisabledAppReasonFfi.NeverStarted -> {
                buf.putInt(1)
                Unit
            }
            is DisabledAppReasonFfi.NotStartedAfterProvidingMemproofs -> {
                buf.putInt(2)
                Unit
            }
            is DisabledAppReasonFfi.DeletingAgentKey -> {
                buf.putInt(3)
                Unit
            }
            is DisabledAppReasonFfi.User -> {
                buf.putInt(4)
                Unit
            }
            is DisabledAppReasonFfi.Error -> {
                buf.putInt(5)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

sealed class PausedAppReasonFfi {
    data class Error(
        val v1: kotlin.String,
    ) : PausedAppReasonFfi() {
        companion object
    }

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypePausedAppReasonFfi : FfiConverterRustBuffer<PausedAppReasonFfi> {
    override fun read(buf: ByteBuffer): PausedAppReasonFfi =
        when (buf.getInt()) {
            1 ->
                PausedAppReasonFfi.Error(
                    FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }

    override fun allocationSize(value: PausedAppReasonFfi) =
        when (value) {
            is PausedAppReasonFfi.Error -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterString.allocationSize(value.v1)
                )
            }
        }

    override fun write(
        value: PausedAppReasonFfi,
        buf: ByteBuffer,
    ) {
        when (value) {
            is PausedAppReasonFfi.Error -> {
                buf.putInt(1)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

sealed class RoleSettingsFfi {
    data class UseExisting(
        val `cellId`: CellIdFfi,
    ) : RoleSettingsFfi() {
        companion object
    }

    data class Provisioned(
        val `membraneProof`: kotlin.ByteArray?,
        val `modifiers`: DnaModifiersOptFfi?,
    ) : RoleSettingsFfi() {
        companion object
    }

    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeRoleSettingsFfi : FfiConverterRustBuffer<RoleSettingsFfi> {
    override fun read(buf: ByteBuffer): RoleSettingsFfi =
        when (buf.getInt()) {
            1 ->
                RoleSettingsFfi.UseExisting(
                    FfiConverterTypeCellIdFfi.read(buf),
                )
            2 ->
                RoleSettingsFfi.Provisioned(
                    FfiConverterOptionalByteArray.read(buf),
                    FfiConverterOptionalTypeDnaModifiersOptFfi.read(buf),
                )
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }

    override fun allocationSize(value: RoleSettingsFfi) =
        when (value) {
            is RoleSettingsFfi.UseExisting -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterTypeCellIdFfi.allocationSize(value.`cellId`)
                )
            }
            is RoleSettingsFfi.Provisioned -> {
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                (
                    4UL +
                        FfiConverterOptionalByteArray.allocationSize(value.`membraneProof`) +
                        FfiConverterOptionalTypeDnaModifiersOptFfi.allocationSize(value.`modifiers`)
                )
            }
        }

    override fun write(
        value: RoleSettingsFfi,
        buf: ByteBuffer,
    ) {
        when (value) {
            is RoleSettingsFfi.UseExisting -> {
                buf.putInt(1)
                FfiConverterTypeCellIdFfi.write(value.`cellId`, buf)
                Unit
            }
            is RoleSettingsFfi.Provisioned -> {
                buf.putInt(2)
                FfiConverterOptionalByteArray.write(value.`membraneProof`, buf)
                FfiConverterOptionalTypeDnaModifiersOptFfi.write(value.`modifiers`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalLong : FfiConverterRustBuffer<kotlin.Long?> {
    override fun read(buf: ByteBuffer): kotlin.Long? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterLong.read(buf)
    }

    override fun allocationSize(value: kotlin.Long?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterLong.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.Long?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterLong.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalString : FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.String?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalByteArray : FfiConverterRustBuffer<kotlin.ByteArray?> {
    override fun read(buf: ByteBuffer): kotlin.ByteArray? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterByteArray.read(buf)
    }

    override fun allocationSize(value: kotlin.ByteArray?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterByteArray.allocationSize(value)
        }
    }

    override fun write(
        value: kotlin.ByteArray?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterByteArray.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalTypeDnaModifiersOptFfi : FfiConverterRustBuffer<DnaModifiersOptFfi?> {
    override fun read(buf: ByteBuffer): DnaModifiersOptFfi? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDnaModifiersOptFfi.read(buf)
    }

    override fun allocationSize(value: DnaModifiersOptFfi?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDnaModifiersOptFfi.allocationSize(value)
        }
    }

    override fun write(
        value: DnaModifiersOptFfi?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDnaModifiersOptFfi.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalTypeDurationFfi : FfiConverterRustBuffer<DurationFfi?> {
    override fun read(buf: ByteBuffer): DurationFfi? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeDurationFfi.read(buf)
    }

    override fun allocationSize(value: DurationFfi?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeDurationFfi.allocationSize(value)
        }
    }

    override fun write(
        value: DurationFfi?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeDurationFfi.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterOptionalMapStringTypeRoleSettingsFfi : FfiConverterRustBuffer<Map<kotlin.String, RoleSettingsFfi>?> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, RoleSettingsFfi>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterMapStringTypeRoleSettingsFfi.read(buf)
    }

    override fun allocationSize(value: Map<kotlin.String, RoleSettingsFfi>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterMapStringTypeRoleSettingsFfi.allocationSize(value)
        }
    }

    override fun write(
        value: Map<kotlin.String, RoleSettingsFfi>?,
        buf: ByteBuffer,
    ) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterMapStringTypeRoleSettingsFfi.write(value, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterSequenceTypeCellInfoFfi : FfiConverterRustBuffer<List<CellInfoFfi>> {
    override fun read(buf: ByteBuffer): List<CellInfoFfi> {
        val len = buf.getInt()
        return List<CellInfoFfi>(len) {
            FfiConverterTypeCellInfoFfi.read(buf)
        }
    }

    override fun allocationSize(value: List<CellInfoFfi>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeCellInfoFfi.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(
        value: List<CellInfoFfi>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeCellInfoFfi.write(it, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterMapStringTypeRoleSettingsFfi : FfiConverterRustBuffer<Map<kotlin.String, RoleSettingsFfi>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, RoleSettingsFfi> {
        val len = buf.getInt()
        return buildMap<kotlin.String, RoleSettingsFfi>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterTypeRoleSettingsFfi.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, RoleSettingsFfi>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren =
            value
                .map { (k, v) ->
                    FfiConverterString.allocationSize(k) +
                        FfiConverterTypeRoleSettingsFfi.allocationSize(v)
                }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(
        value: Map<kotlin.String, RoleSettingsFfi>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeRoleSettingsFfi.write(v, buf)
        }
    }
}

/**
 * @suppress
 */
public object FfiConverterMapStringSequenceTypeCellInfoFfi : FfiConverterRustBuffer<Map<kotlin.String, List<CellInfoFfi>>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, List<CellInfoFfi>> {
        val len = buf.getInt()
        return buildMap<kotlin.String, List<CellInfoFfi>>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterSequenceTypeCellInfoFfi.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, List<CellInfoFfi>>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren =
            value
                .map { (k, v) ->
                    FfiConverterString.allocationSize(k) +
                        FfiConverterSequenceTypeCellInfoFfi.allocationSize(v)
                }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(
        value: Map<kotlin.String, List<CellInfoFfi>>,
        buf: ByteBuffer,
    ) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterSequenceTypeCellInfoFfi.write(v, buf)
        }
    }
}
